/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.profiler;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.profiler.Profiler;

public class ProfilerRegistry {
    private static final InheritableThreadLocal<ProfilerRegistry> inheritableThreadLocal = new InheritableThreadLocal();
    Map<String, Profiler> profilerMap = new HashMap<String, Profiler>();

    public void put(Profiler profiler) {
        this.put(profiler.getName(), profiler);
    }

    public void put(String name, Profiler profiler) {
        this.profilerMap.put(name, profiler);
    }

    public static ProfilerRegistry getThreadContextInstance() {
        ProfilerRegistry pr = (ProfilerRegistry)inheritableThreadLocal.get();
        if (pr == null) {
            pr = new ProfilerRegistry();
            inheritableThreadLocal.set(pr);
        }
        return pr;
    }

    public Profiler get(String name) {
        return this.profilerMap.get(name);
    }

    public void clear() {
        this.profilerMap.clear();
    }
}

