/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.permission.evaluator.Evaluators;
import org.keycloak.authorization.policy.evaluation.DefaultPolicyEvaluator;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.provider.Provider;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;

public final class AuthorizationProvider
implements Provider {
    private final DefaultPolicyEvaluator policyEvaluator;
    private StoreFactory storeFactory;
    private final Map<String, PolicyProviderFactory> policyProviderFactories;
    private final KeycloakSession keycloakSession;
    private final RealmModel realm;

    public AuthorizationProvider(KeycloakSession session, RealmModel realm, StoreFactory storeFactory, Map<String, PolicyProviderFactory> policyProviderFactories) {
        this.keycloakSession = session;
        this.realm = realm;
        this.storeFactory = storeFactory;
        this.policyProviderFactories = policyProviderFactories;
        this.policyEvaluator = new DefaultPolicyEvaluator(this);
    }

    public Evaluators evaluators() {
        return new Evaluators(this.policyEvaluator);
    }

    public StoreFactory getStoreFactory() {
        return this.createStoreFactory();
    }

    private StoreFactory createStoreFactory() {
        return new StoreFactory(){

            @Override
            public ResourceStore getResourceStore() {
                return AuthorizationProvider.this.storeFactory.getResourceStore();
            }

            @Override
            public ResourceServerStore getResourceServerStore() {
                return AuthorizationProvider.this.storeFactory.getResourceServerStore();
            }

            @Override
            public ScopeStore getScopeStore() {
                return AuthorizationProvider.this.storeFactory.getScopeStore();
            }

            @Override
            public PolicyStore getPolicyStore() {
                final PolicyStore policyStore = AuthorizationProvider.this.storeFactory.getPolicyStore();
                return new PolicyStore(){

                    @Override
                    public Policy create(AbstractPolicyRepresentation representation, ResourceServer resourceServer) {
                        return RepresentationToModel.toModel(representation, AuthorizationProvider.this, policyStore.create(representation, resourceServer));
                    }

                    @Override
                    public void delete(String id) {
                        Policy policy = this.findById(id, null);
                        if (policy != null) {
                            Object resourceServer = policy.getResourceServer();
                            this.findDependentPolicies(policy.getId(), resourceServer.getId()).forEach(dependentPolicy -> {
                                dependentPolicy.removeAssociatedPolicy(policy);
                                if (dependentPolicy.getAssociatedPolicies().isEmpty()) {
                                    this.delete(dependentPolicy.getId());
                                }
                            });
                            policyStore.delete(id);
                        }
                    }

                    @Override
                    public Policy findById(String id, String resourceServerId) {
                        return policyStore.findById(id, resourceServerId);
                    }

                    @Override
                    public Policy findByName(String name, String resourceServerId) {
                        return policyStore.findByName(name, resourceServerId);
                    }

                    @Override
                    public List<Policy> findByResourceServer(String resourceServerId) {
                        return policyStore.findByResourceServer(resourceServerId);
                    }

                    @Override
                    public List<Policy> findByResourceServer(Map<String, String[]> attributes, String resourceServerId, int firstResult, int maxResult) {
                        return policyStore.findByResourceServer(attributes, resourceServerId, firstResult, maxResult);
                    }

                    @Override
                    public List<Policy> findByResource(String resourceId, String resourceServerId) {
                        return policyStore.findByResource(resourceId, resourceServerId);
                    }

                    @Override
                    public List<Policy> findByResourceType(String resourceType, String resourceServerId) {
                        return policyStore.findByResourceType(resourceType, resourceServerId);
                    }

                    @Override
                    public List<Policy> findByScopeIds(List<String> scopeIds, String resourceServerId) {
                        return policyStore.findByScopeIds(scopeIds, resourceServerId);
                    }

                    @Override
                    public List<Policy> findByType(String type, String resourceServerId) {
                        return policyStore.findByType(type, resourceServerId);
                    }

                    @Override
                    public List<Policy> findDependentPolicies(String id, String resourceServerId) {
                        return policyStore.findDependentPolicies(id, resourceServerId);
                    }
                };
            }

            public void close() {
                AuthorizationProvider.this.storeFactory.close();
            }
        };
    }

    public Collection<PolicyProviderFactory> getProviderFactories() {
        return this.policyProviderFactories.values();
    }

    public <F extends PolicyProviderFactory> F getProviderFactory(String type) {
        return (F)this.policyProviderFactories.get(type);
    }

    public <P extends PolicyProvider> P getProvider(String type) {
        PolicyProviderFactory policyProviderFactory = this.policyProviderFactories.get(type);
        if (policyProviderFactory == null) {
            return null;
        }
        return (P)policyProviderFactory.create(this);
    }

    public KeycloakSession getKeycloakSession() {
        return this.keycloakSession;
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public void close() {
    }
}

