/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.authorization.infinispan.entities;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Logic;

public class CachedPolicy
implements Policy,
Serializable {
    private static final long serialVersionUID = -144247681046298128L;
    private String id;
    private String type;
    private DecisionStrategy decisionStrategy;
    private Logic logic;
    private Map<String, String> config;
    private String name;
    private String description;
    private String resourceServerId;
    private Set<String> associatedPoliciesIds;
    private Set<String> resourcesIds;
    private Set<String> scopesIds;

    public CachedPolicy(Policy policy) {
        this.id = policy.getId();
        this.type = policy.getType();
        this.decisionStrategy = policy.getDecisionStrategy();
        this.logic = policy.getLogic();
        this.config = new HashMap<String, String>(policy.getConfig());
        this.name = policy.getName();
        this.description = policy.getDescription();
        this.resourceServerId = policy.getResourceServer().getId();
        this.associatedPoliciesIds = policy.getAssociatedPolicies().stream().map(Policy::getId).collect(Collectors.toSet());
        this.resourcesIds = policy.getResources().stream().map(Resource::getId).collect(Collectors.toSet());
        this.scopesIds = policy.getScopes().stream().map(Scope::getId).collect(Collectors.toSet());
    }

    public CachedPolicy(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public DecisionStrategy getDecisionStrategy() {
        return this.decisionStrategy;
    }

    public void setDecisionStrategy(DecisionStrategy decisionStrategy) {
        this.decisionStrategy = decisionStrategy;
    }

    public Logic getLogic() {
        return this.logic;
    }

    public void setLogic(Logic logic) {
        this.logic = logic;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, String> config) {
        this.config = config;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ResourceServer getResourceServer() {
        throw new RuntimeException("Not implemented");
    }

    public void addScope(Scope scope) {
        this.scopesIds.add(scope.getId());
    }

    public void removeScope(Scope scope) {
        this.scopesIds.remove(scope.getId());
    }

    public void addAssociatedPolicy(Policy associatedPolicy) {
        this.associatedPoliciesIds.add(associatedPolicy.getId());
    }

    public void removeAssociatedPolicy(Policy associatedPolicy) {
        this.associatedPoliciesIds.remove(associatedPolicy.getId());
    }

    public void addResource(Resource resource) {
        this.resourcesIds.add(resource.getId());
    }

    public void removeResource(Resource resource) {
        this.resourcesIds.remove(resource.getId());
    }

    public Set<Policy> getAssociatedPolicies() {
        throw new RuntimeException("Not implemented");
    }

    public Set<Resource> getResources() {
        throw new RuntimeException("Not implemented");
    }

    public Set<Scope> getScopes() {
        throw new RuntimeException("Not implemented");
    }

    public Set<String> getAssociatedPoliciesIds() {
        return this.associatedPoliciesIds;
    }

    public Set<String> getResourcesIds() {
        return this.resourcesIds;
    }

    public Set<String> getScopesIds() {
        return this.scopesIds;
    }

    public String getResourceServerId() {
        return this.resourceServerId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (this.id == null) {
            return false;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Policy that = (Policy)o;
        return this.getId().equals(that.getId());
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : super.hashCode();
    }
}

