/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.BackupForConfiguration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.LockingConfiguration;
import org.infinispan.configuration.cache.PartitionHandlingConfiguration;
import org.infinispan.configuration.cache.SitesConfiguration;
import org.infinispan.configuration.cache.SitesConfigurationBuilder;
import org.infinispan.configuration.cache.StateTransferConfiguration;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheBuilder;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;

public class SharedStateCacheBuilder
extends ClusteredCacheBuilder {
    private final InjectedValue<PartitionHandlingConfiguration> partitionHandling = new InjectedValue();
    private final InjectedValue<StateTransferConfiguration> stateTransfer = new InjectedValue();
    private final InjectedValue<BackupForConfiguration> backupFor = new InjectedValue();
    private final InjectedValue<SitesConfiguration> backups = new InjectedValue();
    private final InjectedValue<TransactionConfiguration> transaction = new InjectedValue();
    private final InjectedValue<LockingConfiguration> locking = new InjectedValue();
    private final String containerName;
    private final String cacheName;

    SharedStateCacheBuilder(String containerName, String cacheName, CacheMode mode) {
        super(containerName, cacheName, mode);
        this.containerName = containerName;
        this.cacheName = cacheName;
    }

    @Override
    public ServiceBuilder<Configuration> build(ServiceTarget target) {
        return super.build(target).addDependency(CacheComponent.PARTITION_HANDLING.getServiceName(this.containerName, this.cacheName), PartitionHandlingConfiguration.class, this.partitionHandling).addDependency(CacheComponent.STATE_TRANSFER.getServiceName(this.containerName, this.cacheName), StateTransferConfiguration.class, this.stateTransfer).addDependency(CacheComponent.BACKUPS.getServiceName(this.containerName, this.cacheName), SitesConfiguration.class, this.backups).addDependency(CacheComponent.BACKUP_FOR.getServiceName(this.containerName, this.cacheName), BackupForConfiguration.class, this.backupFor).addDependency(CacheComponent.TRANSACTION.getServiceName(this.containerName, this.cacheName), TransactionConfiguration.class, this.transaction).addDependency(CacheComponent.LOCKING.getServiceName(this.containerName, this.cacheName), LockingConfiguration.class, this.locking);
    }

    @Override
    public ConfigurationBuilder createConfigurationBuilder() {
        ConfigurationBuilder builder = super.createConfigurationBuilder();
        builder.clustering().partitionHandling().read((PartitionHandlingConfiguration)this.partitionHandling.getValue());
        builder.clustering().stateTransfer().read((StateTransferConfiguration)this.stateTransfer.getValue());
        CacheMode mode = builder.clustering().cacheMode();
        if (mode.isSynchronous() && ((TransactionConfiguration)this.transaction.getValue()).lockingMode() == LockingMode.OPTIMISTIC && ((LockingConfiguration)this.locking.getValue()).isolationLevel() == IsolationLevel.REPEATABLE_READ) {
            builder.locking().writeSkewCheck(true);
            builder.versioning().enable().scheme(VersioningScheme.SIMPLE);
        }
        SitesConfigurationBuilder sitesBuilder = builder.sites();
        sitesBuilder.read((SitesConfiguration)this.backups.getValue());
        sitesBuilder.backupFor().read((BackupForConfiguration)this.backupFor.getValue());
        return builder;
    }
}

