/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spi;

import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public enum IndexingMode {
    EVENT("event"),
    MANUAL("manual");

    private static Log LOG;
    private String externalRepresentation;

    private IndexingMode(String externalRepresentation) {
        this.externalRepresentation = externalRepresentation;
    }

    public static IndexingMode fromExternalRepresentation(String indexingMode) {
        if (EVENT.toExternalRepresentation().equals(indexingMode)) {
            return EVENT;
        }
        if (MANUAL.toExternalRepresentation().equals(indexingMode)) {
            return MANUAL;
        }
        throw LOG.unknownIndexingMode(indexingMode);
    }

    public String toExternalRepresentation() {
        return this.externalRepresentation;
    }

    static {
        LOG = LoggerFactory.make();
    }
}

