/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.managedbean.component.ManagedBeanComponentDescription;
import org.jboss.as.ee.weld.WeldDeploymentMarker;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.AnnotationIndexUtils;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.weld.deployment.ExplicitBeanArchiveMetadataContainer;
import org.jboss.as.weld.deployment.WeldAttachments;
import org.jboss.as.weld.deployment.processors.WeldConfiguration;
import org.jboss.as.weld.discovery.AnnotationType;
import org.jboss.as.weld.util.Utils;
import org.jboss.jandex.Index;

public class WeldImplicitDeploymentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (WeldDeploymentMarker.isWeldDeployment((DeploymentUnit)deploymentUnit)) {
            return;
        }
        if (((WeldConfiguration)Utils.getRootDeploymentUnit(deploymentUnit).getAttachment(WeldConfiguration.ATTACHMENT_KEY)).isRequireBeanDescriptor()) {
            return;
        }
        HashSet beanDefiningAnnotations = new HashSet((Collection)Utils.getRootDeploymentUnit(deploymentUnit).getAttachment(WeldAttachments.BEAN_DEFINING_ANNOTATIONS));
        Map indexes = AnnotationIndexUtils.getAnnotationIndexes((DeploymentUnit)deploymentUnit);
        ExplicitBeanArchiveMetadataContainer explicitBeanArchiveMetadata = (ExplicitBeanArchiveMetadataContainer)deploymentUnit.getAttachment(ExplicitBeanArchiveMetadataContainer.ATTACHMENT_KEY);
        ResourceRoot classesRoot = (ResourceRoot)deploymentUnit.getAttachment(WeldAttachments.CLASSES_RESOURCE_ROOT);
        ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_ROOT);
        for (Map.Entry entry : indexes.entrySet()) {
            ResourceRoot resourceRoot = (ResourceRoot)entry.getKey();
            if (resourceRoot == classesRoot) {
                resourceRoot = deploymentRoot;
            }
            if (explicitBeanArchiveMetadata != null && explicitBeanArchiveMetadata.getBeanArchiveMetadata().containsKey(resourceRoot)) continue;
            for (AnnotationType annotation : beanDefiningAnnotations) {
                if (((Index)entry.getValue()).getAnnotations(annotation.getName()).isEmpty()) continue;
                WeldDeploymentMarker.mark((DeploymentUnit)deploymentUnit);
                return;
            }
        }
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        for (ComponentDescription component : eeModuleDescription.getComponentDescriptions()) {
            if (!(component instanceof SessionBeanComponentDescription) && !(component instanceof ManagedBeanComponentDescription)) continue;
            WeldDeploymentMarker.mark((DeploymentUnit)deploymentUnit);
            return;
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

