/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.role;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.keycloak.Config;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.policy.provider.role.RolePolicyProvider;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.RolePolicyRepresentation;
import org.keycloak.util.JsonSerialization;

public class RolePolicyProviderFactory
implements PolicyProviderFactory<RolePolicyRepresentation> {
    private RolePolicyProvider provider = new RolePolicyProvider(policy -> this.toRepresentation((Policy)policy, new RolePolicyRepresentation()));

    public String getName() {
        return "Role";
    }

    public String getGroup() {
        return "Identity Based";
    }

    public PolicyProvider create(AuthorizationProvider authorization) {
        return this.provider;
    }

    public PolicyProvider create(KeycloakSession session) {
        return this.provider;
    }

    public RolePolicyRepresentation toRepresentation(Policy policy, RolePolicyRepresentation representation) {
        try {
            representation.setRoles(new HashSet<Object>(Arrays.asList((Object[])JsonSerialization.readValue((String)((String)policy.getConfig().get("roles")), RolePolicyRepresentation.RoleDefinition[].class))));
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to deserialize roles", cause);
        }
        return representation;
    }

    public Class<RolePolicyRepresentation> getRepresentationType() {
        return RolePolicyRepresentation.class;
    }

    public void onCreate(Policy policy, RolePolicyRepresentation representation, AuthorizationProvider authorization) {
        this.updateRoles(policy, representation, authorization);
    }

    public void onUpdate(Policy policy, RolePolicyRepresentation representation, AuthorizationProvider authorization) {
        this.updateRoles(policy, representation, authorization);
    }

    public void onImport(Policy policy, PolicyRepresentation representation, AuthorizationProvider authorization) {
        try {
            this.updateRoles(policy, authorization, new HashSet<Object>(Arrays.asList((Object[])JsonSerialization.readValue((String)((String)representation.getConfig().get("roles")), RolePolicyRepresentation.RoleDefinition[].class))));
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to deserialize roles during import", cause);
        }
    }

    private void updateRoles(Policy policy, RolePolicyRepresentation representation, AuthorizationProvider authorization) {
        this.updateRoles(policy, authorization, representation.getRoles());
    }

    private void updateRoles(Policy policy, AuthorizationProvider authorization, Set<RolePolicyRepresentation.RoleDefinition> roles) {
        RealmModel realm = authorization.getRealm();
        HashSet<RolePolicyRepresentation.RoleDefinition> updatedRoles = new HashSet<RolePolicyRepresentation.RoleDefinition>();
        if (roles != null) {
            for (RolePolicyRepresentation.RoleDefinition definition : roles) {
                RoleModel role;
                String roleName = definition.getId();
                String clientId = null;
                int clientIdSeparator = roleName.indexOf("/");
                if (clientIdSeparator != -1) {
                    clientId = roleName.substring(0, clientIdSeparator);
                    roleName = roleName.substring(clientIdSeparator + 1);
                }
                if (clientId == null) {
                    role = realm.getRole(roleName);
                    if (role == null) {
                        role = realm.getRoleById(roleName);
                    }
                } else {
                    ClientModel client = realm.getClientByClientId(clientId);
                    if (client == null) {
                        throw new RuntimeException("Client with id [" + clientId + "] not found.");
                    }
                    role = client.getRole(roleName);
                }
                if (role == null) {
                    String finalRoleName = roleName;
                    role = realm.getClients().stream().map(clientModel -> clientModel.getRole(finalRoleName)).filter(roleModel -> roleModel != null).findFirst().orElse(null);
                }
                if (role == null) {
                    throw new RuntimeException("Error while updating policy [" + policy.getName() + "]. Role [" + roleName + "] could not be found.");
                }
                definition.setId(role.getId());
                updatedRoles.add(definition);
            }
        }
        try {
            Map config = policy.getConfig();
            config.put("roles", JsonSerialization.writeValueAsString(updatedRoles));
            policy.setConfig(config);
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to serialize roles", cause);
        }
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        factory.register(event -> {
            if (event instanceof RoleContainerModel.RoleRemovedEvent) {
                KeycloakSession keycloakSession = ((RoleContainerModel.RoleRemovedEvent)event).getKeycloakSession();
                AuthorizationProvider provider = (AuthorizationProvider)keycloakSession.getProvider(AuthorizationProvider.class);
                StoreFactory storeFactory = provider.getStoreFactory();
                PolicyStore policyStore = storeFactory.getPolicyStore();
                RoleModel removedRole = ((RoleContainerModel.RoleRemovedEvent)event).getRole();
                RoleContainerModel container = removedRole.getContainer();
                ResourceServerStore resourceServerStore = storeFactory.getResourceServerStore();
                if (container instanceof RealmModel) {
                    RealmModel realm = (RealmModel)container;
                    realm.getClients().forEach(clientModel -> this.updateResourceServer((ClientModel)clientModel, removedRole, resourceServerStore, policyStore));
                } else {
                    ClientModel clientModel2 = (ClientModel)container;
                    this.updateResourceServer(clientModel2, removedRole, resourceServerStore, policyStore);
                }
            }
        });
    }

    private void updateResourceServer(ClientModel clientModel, RoleModel removedRole, ResourceServerStore resourceServerStore, PolicyStore policyStore) {
        ResourceServer resourceServer = resourceServerStore.findByClient(clientModel.getId());
        if (resourceServer != null) {
            policyStore.findByType(this.getId(), resourceServer.getId()).forEach(policy -> {
                ArrayList roles = new ArrayList();
                for (Map<String, Object> role : this.getRoles((Policy)policy)) {
                    if (role.get("id").equals(removedRole.getId())) continue;
                    HashMap<String, Object> updated = new HashMap<String, Object>();
                    updated.put("id", role.get("id"));
                    Object required = role.get("required");
                    if (required != null) {
                        updated.put("required", required);
                    }
                    roles.add(updated);
                }
                try {
                    if (roles.isEmpty()) {
                        policyStore.delete(policy.getId());
                    } else {
                        Map config = policy.getConfig();
                        config.put("roles", JsonSerialization.writeValueAsString(roles));
                        policy.setConfig(config);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Error while synchronizing roles with policy [" + policy.getName() + "].", e);
                }
            });
        }
    }

    public void close() {
    }

    public String getId() {
        return "role";
    }

    private Map<String, Object>[] getRoles(Policy policy) {
        String roles = (String)policy.getConfig().get("roles");
        if (roles != null) {
            try {
                return (Map[])JsonSerialization.readValue((byte[])roles.getBytes(), Map[].class);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not parse roles [" + roles + "] from policy config [" + policy.getName() + ".", e);
            }
        }
        return new Map[0];
    }
}

