/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.util.ArrayList;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.services.resourceadapters.statistics.ResourceAdapterStatisticsService;
import org.jboss.as.connector.subsystems.resourceadapters.CommonAttributes;
import org.jboss.as.connector.subsystems.resourceadapters.Constants;
import org.jboss.as.connector.subsystems.resourceadapters.IronJacamarResource;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableResourceAdapter;
import org.jboss.as.connector.subsystems.resourceadapters.RaOperationUtil;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.api.metadata.resourceadapter.Activation;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class RaAdd
extends AbstractAddStepHandler {
    static final RaAdd INSTANCE = new RaAdd();

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attribute : CommonAttributes.RESOURCE_ADAPTER_ATTRIBUTE) {
            attribute.validateAndSet(operation, model);
        }
    }

    public void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        ModelNode model = resource.getModel();
        if (Constants.ELYTRON_ENABLED.resolveModelAttribute(context, model).asBoolean()) {
            if (model.hasDefined(Constants.SECURITY_DOMAIN.getName())) {
                throw ConnectorLogger.SUBSYSTEM_RA_LOGGER.attributeRequiresFalseOrUndefinedAttribute(Constants.SECURITY_DOMAIN.getName(), Constants.ELYTRON_ENABLED.getName());
            }
            if (model.hasDefined(Constants.SECURITY_DOMAIN_AND_APPLICATION.getName())) {
                throw ConnectorLogger.SUBSYSTEM_RA_LOGGER.attributeRequiresFalseOrUndefinedAttribute(Constants.SECURITY_DOMAIN_AND_APPLICATION.getName(), Constants.ELYTRON_ENABLED.getName());
            }
            if (model.hasDefined(Constants.APPLICATION.getName())) {
                throw ConnectorLogger.SUBSYSTEM_RA_LOGGER.attributeRequiresFalseOrUndefinedAttribute(Constants.APPLICATION.getName(), Constants.ELYTRON_ENABLED.getName());
            }
        } else {
            if (model.hasDefined(Constants.AUTHENTICATION_CONTEXT.getName())) {
                throw ConnectorLogger.SUBSYSTEM_RA_LOGGER.attributeRequiresTrueAttribute(Constants.AUTHENTICATION_CONTEXT.getName(), Constants.ELYTRON_ENABLED.getName());
            }
            if (model.hasDefined(Constants.AUTHENTICATION_CONTEXT_AND_APPLICATION.getName())) {
                throw ConnectorLogger.SUBSYSTEM_RA_LOGGER.attributeRequiresTrueAttribute(Constants.AUTHENTICATION_CONTEXT_AND_APPLICATION.getName(), Constants.ELYTRON_ENABLED.getName());
            }
        }
        if (Constants.RECOVERY_ELYTRON_ENABLED.resolveModelAttribute(context, model).asBoolean()) {
            if (model.hasDefined(Constants.RECOVERY_SECURITY_DOMAIN.getName())) {
                throw ConnectorLogger.SUBSYSTEM_RA_LOGGER.attributeRequiresFalseOrUndefinedAttribute(Constants.RECOVERY_SECURITY_DOMAIN.getName(), Constants.RECOVERY_ELYTRON_ENABLED.getName());
            }
        } else if (model.hasDefined(Constants.RECOVERY_AUTHENTICATION_CONTEXT.getName())) {
            throw ConnectorLogger.SUBSYSTEM_RA_LOGGER.attributeRequiresTrueAttribute(Constants.RECOVERY_AUTHENTICATION_CONTEXT.getName(), Constants.RECOVERY_ELYTRON_ENABLED.getName());
        }
        final String name = context.getCurrentAddressValue();
        boolean statsEnabled = Constants.STATISTICS_ENABLED.resolveModelAttribute(context, model).asBoolean();
        if (!model.hasDefined(Constants.ARCHIVE.getName()) && !model.hasDefined(Constants.MODULE.getName())) {
            throw ConnectorLogger.ROOT_LOGGER.archiveOrModuleRequired();
        }
        final String archiveOrModuleName = model.get(Constants.ARCHIVE.getName()).isDefined() ? model.get(Constants.ARCHIVE.getName()).asString() : model.get(Constants.MODULE.getName()).asString();
        ModifiableResourceAdapter resourceAdapter = RaOperationUtil.buildResourceAdaptersObject(name, context, operation, archiveOrModuleName);
        ArrayList newControllers = new ArrayList();
        if (model.get(Constants.ARCHIVE.getName()).isDefined()) {
            RaOperationUtil.installRaServices(context, name, resourceAdapter, newControllers);
        } else {
            RaOperationUtil.installRaServicesAndDeployFromModule(context, name, resourceAdapter, archiveOrModuleName, newControllers);
            if (context.isBooting()) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        ServiceName restartedServiceName = RaOperationUtil.restartIfPresent(context, archiveOrModuleName, name);
                        if (restartedServiceName == null) {
                            RaOperationUtil.activate(context, name, archiveOrModuleName);
                        }
                        context.completeStep(new OperationContext.RollbackHandler(){

                            public void handleRollback(OperationContext context, ModelNode operation) {
                                try {
                                    RaOperationUtil.removeIfActive(context, archiveOrModuleName, name);
                                }
                                catch (OperationFailedException operationFailedException) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController RaxmlController = registry.getService(ServiceName.of((ServiceName)ConnectorServices.RA_SERVICE, (String[])new String[]{name}));
        Activation raxml = (Activation)RaxmlController.getValue();
        ServiceName serviceName = ConnectorServices.getDeploymentServiceName(archiveOrModuleName, name);
        String bootStrapCtxName = "default";
        if (raxml.getBootstrapContext() != null && !raxml.getBootstrapContext().equals("undefined")) {
            bootStrapCtxName = raxml.getBootstrapContext();
        }
        ResourceAdapterStatisticsService raStatsService = new ResourceAdapterStatisticsService(context.getResourceRegistrationForUpdate(), name, statsEnabled);
        ServiceBuilder statsServiceBuilder = context.getServiceTarget().addService(ServiceName.of((ServiceName)ConnectorServices.RA_SERVICE, (String[])new String[]{name}).append(new String[]{"STATISTICS"}), (Service)raStatsService);
        statsServiceBuilder.addDependency(ConnectorServices.BOOTSTRAP_CONTEXT_SERVICE.append(new String[]{bootStrapCtxName}), raStatsService.getBootstrapContextInjector()).addDependency(serviceName, raStatsService.getResourceAdapterDeploymentInjector()).setInitialMode(ServiceController.Mode.PASSIVE).install();
        PathElement peStats = PathElement.pathElement((String)"statistics", (String)"extended");
        IronJacamarResource.IronJacamarRuntimeResource statsResource = new IronJacamarResource.IronJacamarRuntimeResource();
        resource.registerChild(peStats, (Resource)statsResource);
    }
}

