/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.microsoft;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URLEncoder;
import org.jboss.logging.Logger;
import org.keycloak.broker.oidc.AbstractOAuth2IdentityProvider;
import org.keycloak.broker.oidc.OAuth2IdentityProviderConfig;
import org.keycloak.broker.oidc.mappers.AbstractJsonUserAttributeMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.models.KeycloakSession;

public class MicrosoftIdentityProvider
extends AbstractOAuth2IdentityProvider
implements SocialIdentityProvider {
    private static final Logger log = Logger.getLogger(MicrosoftIdentityProvider.class);
    public static final String AUTH_URL = "https://login.live.com/oauth20_authorize.srf";
    public static final String TOKEN_URL = "https://login.live.com/oauth20_token.srf";
    public static final String PROFILE_URL = "https://apis.live.net/v5.0/me";
    public static final String DEFAULT_SCOPE = "wl.basic,wl.emails";

    public MicrosoftIdentityProvider(KeycloakSession session, OAuth2IdentityProviderConfig config) {
        super(session, config);
        config.setAuthorizationUrl(AUTH_URL);
        config.setTokenUrl(TOKEN_URL);
        config.setUserInfoUrl(PROFILE_URL);
    }

    @Override
    protected BrokeredIdentityContext doGetFederatedIdentity(String accessToken) {
        try {
            String URL2 = "https://apis.live.net/v5.0/me?access_token=" + URLEncoder.encode(accessToken, "UTF-8");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Microsoft Live user profile request to: " + URL2));
            }
            JsonNode profile = SimpleHttp.doGet((String)URL2, (KeycloakSession)this.session).asJson();
            String id = this.getJsonProperty(profile, "id");
            String email = null;
            if (profile.has("emails")) {
                email = this.getJsonProperty(profile.get("emails"), "preferred");
            }
            BrokeredIdentityContext user = new BrokeredIdentityContext(id);
            user.setUsername(email != null ? email : id);
            user.setFirstName(this.getJsonProperty(profile, "first_name"));
            user.setLastName(this.getJsonProperty(profile, "last_name"));
            if (email != null) {
                user.setEmail(email);
            }
            user.setIdpConfig(this.getConfig());
            user.setIdp((IdentityProvider)this);
            AbstractJsonUserAttributeMapper.storeUserProfileForMapper(user, profile, this.getConfig().getAlias());
            return user;
        }
        catch (Exception e) {
            throw new IdentityBrokerException("Could not obtain user profile from Microsoft Live ID.", (Throwable)e);
        }
    }

    @Override
    protected String getDefaultScopes() {
        return DEFAULT_SCOPE;
    }
}

