/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.group;

import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.server.group.CacheNodeFactory;
import org.wildfly.clustering.server.group.InfinispanNodeFactory;
import org.wildfly.clustering.server.group.JGroupsNodeFactory;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.Requirement;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;
import org.wildfly.clustering.spi.ClusteringRequirement;
import org.wildfly.clustering.spi.ServiceNameRegistry;

public class CacheNodeFactoryBuilder
implements CapabilityServiceBuilder<InfinispanNodeFactory> {
    private final ServiceName name;
    private final String containerName;
    private volatile ValueDependency<JGroupsNodeFactory> factory;

    public CacheNodeFactoryBuilder(ServiceNameRegistry<ClusteringCacheRequirement> registry, String containerName) {
        this.name = registry.getServiceName((Requirement)ClusteringCacheRequirement.NODE_FACTORY);
        this.containerName = containerName;
    }

    public ServiceName getServiceName() {
        return this.name;
    }

    public Builder<InfinispanNodeFactory> configure(CapabilityServiceSupport support) {
        this.factory = new InjectedValueDependency(ClusteringRequirement.NODE_FACTORY.getServiceName(support, this.containerName), JGroupsNodeFactory.class);
        return this;
    }

    public ServiceBuilder<InfinispanNodeFactory> build(ServiceTarget target) {
        Value value = () -> new CacheNodeFactory((JGroupsNodeFactory)this.factory.getValue());
        return this.factory.register(target.addService(this.getServiceName(), (Service)new ValueService(value)).setInitialMode(ServiceController.Mode.ON_DEMAND));
    }
}

