/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core.supplier;

import junit.framework.Assert;
import junit.framework.TestCase;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.change.core.CreateTableChange;
import liquibase.change.core.DropDefaultValueChange;
import liquibase.diff.DiffResult;
import liquibase.diff.ObjectDifferences;
import liquibase.sdk.supplier.change.AbstractChangeSupplier;
import liquibase.structure.core.Column;
import liquibase.structure.core.Table;

public class DropDefaultValueChangeSupplier
extends AbstractChangeSupplier<DropDefaultValueChange> {
    public DropDefaultValueChangeSupplier() {
        super(DropDefaultValueChange.class);
    }

    @Override
    public Change[] prepareDatabase(DropDefaultValueChange change) throws Exception {
        CreateTableChange createTableChange = new CreateTableChange();
        createTableChange.setCatalogName(change.getCatalogName());
        createTableChange.setSchemaName(change.getSchemaName());
        createTableChange.setTableName(change.getTableName());
        createTableChange.addColumn(new ColumnConfig().setName("other_col").setType("int"));
        String dataType = change.getColumnDataType();
        if (dataType == null) {
            dataType = "int";
        }
        createTableChange.addColumn(new ColumnConfig().setName(change.getColumnName()).setType(dataType).setDefaultValue("1"));
        return new Change[]{createTableChange};
    }

    @Override
    public void checkDiffResult(DiffResult diffResult, DropDefaultValueChange change) {
        ObjectDifferences diff = diffResult.getChangedObject(new Column(Table.class, change.getCatalogName(), change.getSchemaName(), change.getTableName(), change.getColumnName()));
        TestCase.assertNotNull((Object)diff);
        TestCase.assertNotNull((Object)diff.getDifference("defaultValue").getReferenceValue());
        Assert.assertEquals((String)"NULL", (String)diff.getDifference("defaultValue").getComparedValue().toString());
    }
}

