/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.reflect;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import org.jboss.marshalling.util.Kind;

public final class SerializableField {
    private final Class<?> type;
    private final Field field;
    private final String name;
    private final boolean unshared;
    private final Kind kind;

    public SerializableField(Class<?> type, String name, boolean unshared) {
        this(type, name, unshared, null);
    }

    SerializableField(Class<?> type, String name, boolean unshared, Field field) {
        assert (field == null || field.isAccessible());
        this.type = type;
        this.name = name;
        this.unshared = unshared;
        this.field = field;
        if (field != null) {
            if (field.getType() != type) {
                throw new IllegalStateException("Constructed a serializable field with the wrong type (field type is " + field.getType() + ", our type is " + type + ")");
            }
            if (!field.getName().equals(name)) {
                throw new IllegalStateException("Constructed a serializable field with the wrong name (field name is " + field.getName() + ", our name is " + name + ")");
            }
        }
        this.kind = type == Boolean.TYPE ? Kind.BOOLEAN : (type == Byte.TYPE ? Kind.BYTE : (type == Short.TYPE ? Kind.SHORT : (type == Integer.TYPE ? Kind.INT : (type == Long.TYPE ? Kind.LONG : (type == Character.TYPE ? Kind.CHAR : (type == Float.TYPE ? Kind.FLOAT : (type == Double.TYPE ? Kind.DOUBLE : Kind.OBJECT)))))));
    }

    public Field getField() {
        return this.field;
    }

    public String getName() {
        return this.name;
    }

    public boolean isUnshared() {
        return this.unshared;
    }

    public Kind getKind() {
        return this.kind;
    }

    public Class<?> getType() throws ClassNotFoundException {
        return this.type;
    }

    public void readFrom(Object instance, ObjectInput input) throws IOException, ClassNotFoundException {
        try {
            switch (this.kind) {
                case BOOLEAN: {
                    this.field.setBoolean(instance, input.readBoolean());
                    break;
                }
                case BYTE: {
                    this.field.setByte(instance, input.readByte());
                    break;
                }
                case CHAR: {
                    this.field.setChar(instance, input.readChar());
                    break;
                }
                case DOUBLE: {
                    this.field.setDouble(instance, input.readDouble());
                    break;
                }
                case FLOAT: {
                    this.field.setFloat(instance, input.readFloat());
                    break;
                }
                case INT: {
                    this.field.setInt(instance, input.readInt());
                    break;
                }
                case LONG: {
                    this.field.setLong(instance, input.readLong());
                    break;
                }
                case SHORT: {
                    this.field.setShort(instance, input.readShort());
                    break;
                }
                case OBJECT: {
                    this.field.set(instance, input.readObject());
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (IllegalAccessException e) {
            IllegalAccessError error = new IllegalAccessError(e.getMessage());
            error.setStackTrace(e.getStackTrace());
            throw error;
        }
    }

    public void writeTo(Object instance, ObjectOutput output) throws IOException {
        try {
            switch (this.kind) {
                case BOOLEAN: {
                    output.writeBoolean(this.field.getBoolean(instance));
                    break;
                }
                case BYTE: {
                    output.writeByte(this.field.getByte(instance));
                    break;
                }
                case CHAR: {
                    output.writeChar(this.field.getChar(instance));
                    break;
                }
                case DOUBLE: {
                    output.writeDouble(this.field.getDouble(instance));
                    break;
                }
                case FLOAT: {
                    output.writeFloat(this.field.getFloat(instance));
                    break;
                }
                case INT: {
                    output.writeInt(this.field.getInt(instance));
                    break;
                }
                case LONG: {
                    output.writeLong(this.field.getLong(instance));
                    break;
                }
                case SHORT: {
                    output.writeShort(this.field.getShort(instance));
                    break;
                }
                case OBJECT: {
                    output.writeObject(this.field.get(instance));
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (IllegalAccessException e) {
            IllegalAccessError error = new IllegalAccessError(e.getMessage());
            error.setStackTrace(e.getStackTrace());
            throw error;
        }
    }
}

