/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.event.internal.core;

import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PostCollectionRecreateEvent;
import org.hibernate.event.spi.PostCollectionRecreateEventListener;
import org.hibernate.event.spi.PostCollectionRemoveEvent;
import org.hibernate.event.spi.PostCollectionRemoveEventListener;
import org.hibernate.event.spi.PostCollectionUpdateEvent;
import org.hibernate.event.spi.PostCollectionUpdateEventListener;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.jpa.event.spi.jpa.CallbackRegistry;
import org.hibernate.jpa.event.spi.jpa.CallbackRegistryConsumer;
import org.hibernate.jpa.event.spi.jpa.CallbackType;
import org.hibernate.persister.entity.EntityPersister;

public class JpaPostUpdateEventListener
implements PostUpdateEventListener,
CallbackRegistryConsumer,
PostCollectionRecreateEventListener,
PostCollectionRemoveEventListener,
PostCollectionUpdateEventListener {
    private CallbackRegistry callbackRegistry;

    @Override
    public void injectCallbackRegistry(CallbackRegistry callbackRegistry) {
        this.callbackRegistry = callbackRegistry;
    }

    public JpaPostUpdateEventListener() {
    }

    public JpaPostUpdateEventListener(CallbackRegistry callbackRegistry) {
        this.callbackRegistry = callbackRegistry;
    }

    public void onPostUpdate(PostUpdateEvent event) {
        Object entity = event.getEntity();
        EventSource eventSource = event.getSession();
        this.handlePostUpdate(entity, eventSource);
    }

    private void handlePostUpdate(Object entity, EventSource source) {
        EntityEntry entry = source.getPersistenceContext().getEntry(entity);
        if (Status.DELETED != entry.getStatus()) {
            this.callbackRegistry.postUpdate(entity);
        }
    }

    public boolean requiresPostCommitHanding(EntityPersister persister) {
        return this.callbackRegistry.hasRegisteredCallbacks(persister.getMappedClass(), CallbackType.POST_UPDATE);
    }

    public void onPostRecreateCollection(PostCollectionRecreateEvent event) {
        Object entity = event.getCollection().getOwner();
        EventSource eventSource = event.getSession();
        this.handlePostUpdate(entity, eventSource);
    }

    public void onPostRemoveCollection(PostCollectionRemoveEvent event) {
        Object entity = event.getCollection().getOwner();
        EventSource eventSource = event.getSession();
        this.handlePostUpdate(entity, eventSource);
    }

    public void onPostUpdateCollection(PostCollectionUpdateEvent event) {
        Object entity = event.getCollection().getOwner();
        EventSource eventSource = event.getSession();
        this.handlePostUpdate(entity, eventSource);
    }
}

