/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.deployers.StartupCountdown;
import org.jboss.as.ee.utils.DescriptorUtils;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.interceptors.CancellationFlag;
import org.jboss.as.ejb3.component.session.SessionBeanComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.deployment.DeploymentModuleIdentifier;
import org.jboss.as.ejb3.deployment.DeploymentRepository;
import org.jboss.as.ejb3.deployment.EjbDeploymentInformation;
import org.jboss.as.ejb3.deployment.ModuleDeployment;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.remote.LocalInvocationClassCloner;
import org.jboss.ejb.client.AttachmentKey;
import org.jboss.ejb.client.AttachmentKeys;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.EJBReceiverSessionCreationContext;
import org.jboss.ejb.client.EntityEJBLocator;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.StatelessEJBLocator;
import org.jboss.invocation.InterceptorContext;
import org.jboss.marshalling.cloner.ClassCloner;
import org.jboss.marshalling.cloner.ClassLoaderClassCloner;
import org.jboss.marshalling.cloner.ClonerConfiguration;
import org.jboss.marshalling.cloner.ObjectCloner;
import org.jboss.marshalling.cloner.ObjectCloners;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.manager.WildFlySecurityManager;

public class LocalEjbReceiver
extends EJBReceiver {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final EJBReceiverInvocationContext.ResultProducer.Immediate NULL_RESULT = new EJBReceiverInvocationContext.ResultProducer.Immediate(null);
    private static final AttachmentKey<CancellationFlag> CANCELLATION_FLAG_ATTACHMENT_KEY = new AttachmentKey();
    private final DeploymentRepository deploymentRepository;
    private final boolean allowPassByReference;

    public LocalEjbReceiver(boolean allowPassByReference, DeploymentRepository deploymentRepository) {
        this.allowPassByReference = allowPassByReference;
        this.deploymentRepository = deploymentRepository;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processInvocation(EJBReceiverInvocationContext receiverContext) {
        Object result;
        Object[] parameters;
        boolean async;
        EJBClientInvocationContext invocation = receiverContext.getClientInvocationContext();
        EJBLocator locator = invocation.getLocator();
        EjbDeploymentInformation ejb = this.findBean(locator);
        EJBComponent ejbComponent = ejb.getEjbComponent();
        Class viewClass = invocation.getViewClass();
        ComponentView view = ejb.getView(viewClass.getName());
        if (view == null) {
            throw EjbLogger.ROOT_LOGGER.viewNotFound(viewClass.getName(), ejb.getEjbName());
        }
        if (!ejb.isRemoteView(viewClass.getName())) {
            throw EjbLogger.ROOT_LOGGER.viewNotFound(viewClass.getName(), ejb.getEjbName());
        }
        ClonerConfiguration paramConfig = new ClonerConfiguration();
        paramConfig.setClassCloner((ClassCloner)new ClassLoaderClassCloner(ejb.getDeploymentClassLoader()));
        ObjectCloner parameterCloner = this.createCloner(paramConfig);
        Method method = view.getMethod(invocation.getInvokedMethod().getName(), DescriptorUtils.methodDescriptor((Method)invocation.getInvokedMethod()));
        boolean bl = async = view.isAsynchronous(method) || invocation.isClientAsync();
        if (invocation.getParameters() == null) {
            parameters = EMPTY_OBJECT_ARRAY;
        } else {
            parameters = new Object[invocation.getParameters().length];
            for (int i = 0; i < parameters.length; ++i) {
                parameters[i] = LocalEjbReceiver.clone(method.getParameterTypes()[i], parameterCloner, invocation.getParameters()[i], this.allowPassByReference);
            }
        }
        InterceptorContext interceptorContext = new InterceptorContext();
        interceptorContext.setParameters(parameters);
        interceptorContext.setMethod(method);
        interceptorContext.setTransaction(invocation.getTransaction());
        interceptorContext.setTarget(invocation.getInvokedProxy());
        Map privateAttachments = invocation.getAttachments();
        Map invocationContextData = invocation.getContextData();
        if (invocationContextData == null && privateAttachments.isEmpty()) {
            interceptorContext.setContextData(new HashMap());
        } else {
            boolean txIdAttachmentPresent;
            HashMap data = new HashMap();
            interceptorContext.setContextData(data);
            if (invocationContextData != null) {
                for (Map.Entry entry : invocationContextData.entrySet()) {
                    data.put(entry.getKey(), entry.getValue());
                }
            }
            if (!privateAttachments.isEmpty()) {
                data.put("org.jboss.ejb.client.invocation.attachments", privateAttachments);
            }
            if (txIdAttachmentPresent = privateAttachments.containsKey(AttachmentKeys.TRANSACTION_ID_KEY)) {
                data.put("jboss.transaction.id", privateAttachments.get(AttachmentKeys.TRANSACTION_ID_KEY));
            }
        }
        interceptorContext.putPrivateData(Component.class, (Object)ejbComponent);
        interceptorContext.putPrivateData(ComponentView.class, (Object)view);
        if (locator.isStateful()) {
            interceptorContext.putPrivateData(SessionID.class, (Object)locator.asStateful().getSessionId());
        } else if (locator instanceof EntityEJBLocator) {
            throw EjbLogger.ROOT_LOGGER.ejbNotFoundInDeployment(locator);
        }
        ClonerConfiguration config = new ClonerConfiguration();
        config.setClassCloner((ClassCloner)new LocalInvocationClassCloner(WildFlySecurityManager.getClassLoaderPrivileged(invocation.getInvokedProxy().getClass())));
        ObjectCloner resultCloner = this.createCloner(config);
        if (async) {
            SecurityDomain securityDomain;
            SecurityContext securityContext;
            if (!(ejbComponent instanceof SessionBeanComponent)) throw EjbLogger.ROOT_LOGGER.asyncInvocationOnlyApplicableForSessionBeans();
            CancellationFlag flag = new CancellationFlag();
            SessionBeanComponent component = (SessionBeanComponent)ejbComponent;
            boolean isAsync = view.isAsynchronous(method);
            boolean oneWay = isAsync && method.getReturnType() == Void.TYPE;
            boolean isSessionBean = view.getComponent() instanceof SessionBeanComponent;
            if (isAsync && isSessionBean && !oneWay) {
                interceptorContext.putPrivateData(CancellationFlag.class, (Object)flag);
            }
            if (WildFlySecurityManager.isChecking()) {
                securityContext = AccessController.doPrivileged(SecurityContextAssociation::getSecurityContext);
                securityDomain = AccessController.doPrivileged(SecurityDomain::getCurrent);
            } else {
                securityContext = SecurityContextAssociation.getSecurityContext();
                securityDomain = SecurityDomain.getCurrent();
            }
            SecurityIdentity securityIdentity = securityDomain != null ? securityDomain.getCurrentSecurityIdentity() : null;
            StartupCountdown.Frame frame = StartupCountdown.current();
            Runnable task = () -> {
                if (!flag.runIfNotCancelled()) {
                    receiverContext.requestCancelled();
                    return;
                }
                LocalEjbReceiver.setSecurityContextOnAssociation(securityContext);
                StartupCountdown.restore((StartupCountdown.Frame)frame);
                try {
                    Object result;
                    try {
                        result = view.invoke(interceptorContext);
                    }
                    catch (Exception e) {
                        receiverContext.resultReady((EJBReceiverInvocationContext.ResultProducer)new CloningExceptionProducer(invocation, resultCloner, e, this.allowPassByReference));
                        StartupCountdown.restore(null);
                        LocalEjbReceiver.clearSecurityContextOnAssociation();
                        return;
                    }
                    if (result == null) {
                        receiverContext.resultReady((EJBReceiverInvocationContext.ResultProducer)NULL_RESULT);
                        return;
                    }
                    if (result instanceof Future) {
                        Object asyncValue;
                        boolean intr = Thread.interrupted();
                        try {
                            while (true) {
                                try {
                                    asyncValue = ((Future)result).get();
                                }
                                catch (InterruptedException e) {
                                    intr = true;
                                    continue;
                                }
                                catch (ExecutionException e) {
                                    receiverContext.resultReady((EJBReceiverInvocationContext.ResultProducer)new CloningExceptionProducer(invocation, resultCloner, e, this.allowPassByReference));
                                    if (intr) {
                                        Thread.currentThread().interrupt();
                                    }
                                    StartupCountdown.restore(null);
                                    LocalEjbReceiver.clearSecurityContextOnAssociation();
                                    return;
                                }
                                break;
                            }
                        }
                        finally {
                            if (intr) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        if (asyncValue == null) {
                            receiverContext.resultReady((EJBReceiverInvocationContext.ResultProducer)NULL_RESULT);
                            return;
                        }
                        receiverContext.resultReady((EJBReceiverInvocationContext.ResultProducer)new CloningResultProducer(invocation, resultCloner, asyncValue, this.allowPassByReference));
                        return;
                    }
                    receiverContext.resultReady((EJBReceiverInvocationContext.ResultProducer)new CloningResultProducer(invocation, resultCloner, result, this.allowPassByReference));
                }
                finally {
                    StartupCountdown.restore(null);
                    LocalEjbReceiver.clearSecurityContextOnAssociation();
                }
            };
            invocation.putAttachment(CANCELLATION_FLAG_ATTACHMENT_KEY, (Object)flag);
            interceptorContext.putPrivateData(CancellationFlag.class, (Object)flag);
            ExecutorService executor = component.getAsynchronousExecutor();
            if (executor == null) {
                receiverContext.resultReady((EJBReceiverInvocationContext.ResultProducer)new EJBReceiverInvocationContext.ResultProducer.Failed((Exception)EjbLogger.ROOT_LOGGER.executorIsNull()));
                return;
            } else {
                receiverContext.proceedAsynchronously();
                executor.execute(securityIdentity == null ? task : () -> securityIdentity.runAs(task));
            }
            return;
        }
        try {
            result = view.invoke(interceptorContext);
        }
        catch (Exception e) {
            receiverContext.resultReady((EJBReceiverInvocationContext.ResultProducer)new CloningExceptionProducer(invocation, resultCloner, e, this.allowPassByReference));
            return;
        }
        receiverContext.resultReady((EJBReceiverInvocationContext.ResultProducer)new CloningResultProducer(invocation, resultCloner, result, this.allowPassByReference));
        for (Map.Entry entry : interceptorContext.getContextData().entrySet()) {
            if (!(entry.getValue() instanceof Serializable)) continue;
            invocation.getContextData().put(entry.getKey(), entry.getValue());
        }
    }

    protected boolean cancelInvocation(EJBReceiverInvocationContext receiverContext, boolean cancelIfRunning) {
        CancellationFlag flag = (CancellationFlag)receiverContext.getClientInvocationContext().getAttachment(CANCELLATION_FLAG_ATTACHMENT_KEY);
        return flag != null && flag.cancel(cancelIfRunning);
    }

    private ObjectCloner createCloner(ClonerConfiguration paramConfig) {
        ObjectCloner parameterCloner = WildFlySecurityManager.isChecking() ? (ObjectCloner)WildFlySecurityManager.doUnchecked(() -> ObjectCloners.getSerializingObjectClonerFactory().createCloner(paramConfig)) : ObjectCloners.getSerializingObjectClonerFactory().createCloner(paramConfig);
        return parameterCloner;
    }

    protected SessionID createSession(EJBReceiverSessionCreationContext receiverContext) throws Exception {
        StatelessEJBLocator statelessLocator = receiverContext.getClientInvocationContext().getLocator().asStateless();
        EjbDeploymentInformation ejbInfo = this.findBean((EJBLocator<?>)statelessLocator);
        EJBComponent component = ejbInfo.getEjbComponent();
        if (!(component instanceof StatefulSessionComponent)) {
            throw EjbLogger.ROOT_LOGGER.notStatefulSessionBean(statelessLocator.getAppName(), statelessLocator.getModuleName(), statelessLocator.getDistinctName(), statelessLocator.getBeanName());
        }
        return ((StatefulSessionComponent)component).createSession();
    }

    static Object clone(Class<?> target, ObjectCloner cloner, Object object, boolean allowPassByReference) {
        if (object == null) {
            return null;
        }
        if (target.isPrimitive()) {
            return object;
        }
        if (allowPassByReference && target.isAssignableFrom(object.getClass())) {
            return object;
        }
        return LocalEjbReceiver.clone(cloner, object);
    }

    private static Object clone(ObjectCloner cloner, Object object) {
        if (object == null) {
            return null;
        }
        if (WildFlySecurityManager.isChecking()) {
            return AccessController.doPrivileged(() -> {
                try {
                    return cloner.clone(object);
                }
                catch (Exception e) {
                    throw EjbLogger.ROOT_LOGGER.failedToMarshalEjbParameters(e);
                }
            });
        }
        try {
            return cloner.clone(object);
        }
        catch (Exception e) {
            throw EjbLogger.ROOT_LOGGER.failedToMarshalEjbParameters(e);
        }
    }

    private EjbDeploymentInformation findBean(EJBLocator<?> locator) {
        String appName = locator.getAppName();
        String moduleName = locator.getModuleName();
        String distinctName = locator.getDistinctName();
        String beanName = locator.getBeanName();
        DeploymentModuleIdentifier moduleIdentifier = new DeploymentModuleIdentifier(appName, moduleName, distinctName);
        ModuleDeployment module = this.deploymentRepository.getValue().getModules().get(moduleIdentifier);
        if (module == null) {
            throw EjbLogger.ROOT_LOGGER.unknownDeployment(locator);
        }
        EjbDeploymentInformation ejbInfo = module.getEjbs().get(beanName);
        if (ejbInfo == null) {
            throw EjbLogger.ROOT_LOGGER.ejbNotFoundInDeployment(locator);
        }
        return ejbInfo;
    }

    private static void setSecurityContextOnAssociation(SecurityContext sc) {
        AccessController.doPrivileged(() -> {
            SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
            return null;
        });
    }

    private static void clearSecurityContextOnAssociation() {
        AccessController.doPrivileged(() -> {
            SecurityContextAssociation.clearSecurityContext();
            return null;
        });
    }

    static final class CloningExceptionProducer
    implements EJBReceiverInvocationContext.ResultProducer {
        private final EJBClientInvocationContext invocation;
        private final ObjectCloner resultCloner;
        private final Exception exception;
        private final boolean allowPassByReference;

        CloningExceptionProducer(EJBClientInvocationContext invocation, ObjectCloner resultCloner, Exception exception, boolean allowPassByReference) {
            this.invocation = invocation;
            this.resultCloner = resultCloner;
            this.exception = exception;
            this.allowPassByReference = allowPassByReference;
        }

        public Object getResult() throws Exception {
            throw (Exception)LocalEjbReceiver.clone(this.resultCloner, this.exception);
        }

        public void discardResult() {
        }
    }

    static final class CloningResultProducer
    implements EJBReceiverInvocationContext.ResultProducer {
        private final EJBClientInvocationContext invocation;
        private final ObjectCloner resultCloner;
        private final Object result;
        private final boolean allowPassByReference;

        CloningResultProducer(EJBClientInvocationContext invocation, ObjectCloner resultCloner, Object result, boolean allowPassByReference) {
            this.invocation = invocation;
            this.resultCloner = resultCloner;
            this.result = result;
            this.allowPassByReference = allowPassByReference;
        }

        public Object getResult() throws Exception {
            return LocalEjbReceiver.clone(this.invocation.getInvokedMethod().getReturnType(), this.resultCloner, this.result, this.allowPassByReference);
        }

        public void discardResult() {
        }
    }
}

