/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ApplicationSecurityDomainService
implements Service<ApplicationSecurityDomain> {
    private final InjectedValue<SecurityDomain> securityDomainInjector = new InjectedValue();
    private final Set<RegistrationImpl> registrations = new HashSet<RegistrationImpl>();
    private final boolean enableJacc;
    private ApplicationSecurityDomain applicationSecurityDomain;

    public ApplicationSecurityDomainService(boolean enableJacc) {
        this.enableJacc = enableJacc;
    }

    public void start(StartContext context) throws StartException {
        this.applicationSecurityDomain = new ApplicationSecurityDomain((SecurityDomain)this.securityDomainInjector.getValue(), this.enableJacc);
    }

    public void stop(StopContext context) {
        this.applicationSecurityDomain = null;
    }

    public ApplicationSecurityDomain getValue() throws IllegalStateException, IllegalArgumentException {
        return this.applicationSecurityDomain;
    }

    Injector<SecurityDomain> getSecurityDomainInjector() {
        return this.securityDomainInjector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDeployments() {
        Set<RegistrationImpl> set = this.registrations;
        synchronized (set) {
            Set<String> deploymentNames = this.registrations.stream().map(r -> ((RegistrationImpl)r).deploymentName).collect(Collectors.toSet());
            return deploymentNames.toArray(new String[deploymentNames.size()]);
        }
    }

    public final class ApplicationSecurityDomain {
        private final SecurityDomain securityDomain;
        private final boolean enableJacc;

        public ApplicationSecurityDomain(SecurityDomain securityDomain, boolean enableJacc) {
            this.securityDomain = securityDomain;
            this.enableJacc = enableJacc;
        }

        public SecurityDomain getSecurityDomain() {
            return this.securityDomain;
        }

        public boolean isEnableJacc() {
            return this.enableJacc;
        }

        public BiFunction<String, ClassLoader, Registration> getSecurityFunction() {
            return this::registerElytronDeployment;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Registration registerElytronDeployment(String deploymentName, ClassLoader classLoader) {
            if (WildFlySecurityManager.isChecking()) {
                AccessController.doPrivileged(() -> {
                    this.securityDomain.registerWithClassLoader(classLoader);
                    return null;
                });
            } else {
                this.securityDomain.registerWithClassLoader(classLoader);
            }
            RegistrationImpl registration = new RegistrationImpl(deploymentName, classLoader);
            Set set = ApplicationSecurityDomainService.this.registrations;
            synchronized (set) {
                ApplicationSecurityDomainService.this.registrations.add(registration);
            }
            return registration;
        }
    }

    public static interface Registration {
        public void cancel();
    }

    private class RegistrationImpl
    implements Registration {
        private final String deploymentName;
        private final ClassLoader classLoader;

        private RegistrationImpl(String deploymentName, ClassLoader classLoader) {
            this.deploymentName = deploymentName;
            this.classLoader = classLoader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            if (WildFlySecurityManager.isChecking()) {
                AccessController.doPrivileged(() -> {
                    SecurityDomain.unregisterClassLoader((ClassLoader)this.classLoader);
                    return null;
                });
            } else {
                SecurityDomain.unregisterClassLoader((ClassLoader)this.classLoader);
            }
            Set set = ApplicationSecurityDomainService.this.registrations;
            synchronized (set) {
                ApplicationSecurityDomainService.this.registrations.remove(this);
            }
        }
    }
}

