/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.sessions.infinispan.InfinispanUserSessionProvider;
import org.keycloak.models.sessions.infinispan.UserSessionAdapter;
import org.keycloak.models.sessions.infinispan.changes.InfinispanChangelogBasedTransaction;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdateTask;
import org.keycloak.models.sessions.infinispan.changes.UserSessionClientSessionUpdateTask;
import org.keycloak.models.sessions.infinispan.changes.UserSessionUpdateTask;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;

public class AuthenticatedClientSessionAdapter
implements AuthenticatedClientSessionModel {
    private final AuthenticatedClientSessionEntity entity;
    private final ClientModel client;
    private final InfinispanUserSessionProvider provider;
    private final InfinispanChangelogBasedTransaction updateTx;
    private UserSessionAdapter userSession;

    public AuthenticatedClientSessionAdapter(AuthenticatedClientSessionEntity entity, ClientModel client, UserSessionAdapter userSession, InfinispanUserSessionProvider provider, InfinispanChangelogBasedTransaction updateTx) {
        this.provider = provider;
        this.entity = entity;
        this.client = client;
        this.updateTx = updateTx;
        this.userSession = userSession;
    }

    private void update(UserSessionUpdateTask task) {
        this.updateTx.addTask(this.userSession.getId(), task);
    }

    public void setUserSession(UserSessionModel userSession) {
        final String clientUUID = this.client.getId();
        UserSessionEntity sessionEntity = this.userSession.getEntity();
        if (userSession == null) {
            UserSessionUpdateTask task = new UserSessionUpdateTask(){

                @Override
                public void runUpdate(UserSessionEntity sessionEntity) {
                    sessionEntity.getAuthenticatedClientSessions().remove(clientUUID);
                }
            };
            this.update(task);
            this.userSession = null;
        } else {
            this.userSession = (UserSessionAdapter)userSession;
            UserSessionUpdateTask task = new UserSessionUpdateTask(){

                @Override
                public void runUpdate(UserSessionEntity sessionEntity) {
                    sessionEntity.getAuthenticatedClientSessions().put(clientUUID, AuthenticatedClientSessionAdapter.this.entity);
                }
            };
            this.update(task);
        }
    }

    public UserSessionModel getUserSession() {
        return this.userSession;
    }

    public String getRedirectUri() {
        return this.entity.getRedirectUri();
    }

    public void setRedirectUri(final String uri) {
        UserSessionClientSessionUpdateTask task = new UserSessionClientSessionUpdateTask(this.client.getId()){

            @Override
            protected void runClientSessionUpdate(AuthenticatedClientSessionEntity entity) {
                entity.setRedirectUri(uri);
            }
        };
        this.update(task);
    }

    public String getId() {
        return null;
    }

    public RealmModel getRealm() {
        return this.userSession.getRealm();
    }

    public ClientModel getClient() {
        return this.client;
    }

    public int getTimestamp() {
        return this.entity.getTimestamp();
    }

    public void setTimestamp(final int timestamp) {
        UserSessionClientSessionUpdateTask task = new UserSessionClientSessionUpdateTask(this.client.getId()){

            @Override
            protected void runClientSessionUpdate(AuthenticatedClientSessionEntity entity) {
                entity.setTimestamp(timestamp);
            }

            @Override
            public SessionUpdateTask.CrossDCMessageStatus getCrossDCMessageStatus(SessionEntityWrapper<UserSessionEntity> sessionWrapper) {
                return SessionUpdateTask.CrossDCMessageStatus.NOT_NEEDED;
            }
        };
        this.update(task);
    }

    public String getAction() {
        return this.entity.getAction();
    }

    public void setAction(final String action) {
        UserSessionClientSessionUpdateTask task = new UserSessionClientSessionUpdateTask(this.client.getId()){

            @Override
            protected void runClientSessionUpdate(AuthenticatedClientSessionEntity entity) {
                entity.setAction(action);
            }
        };
        this.update(task);
    }

    public String getProtocol() {
        return this.entity.getAuthMethod();
    }

    public void setProtocol(final String method) {
        UserSessionClientSessionUpdateTask task = new UserSessionClientSessionUpdateTask(this.client.getId()){

            @Override
            protected void runClientSessionUpdate(AuthenticatedClientSessionEntity entity) {
                entity.setAuthMethod(method);
            }
        };
        this.update(task);
    }

    public Set<String> getRoles() {
        return this.entity.getRoles();
    }

    public void setRoles(final Set<String> roles) {
        UserSessionClientSessionUpdateTask task = new UserSessionClientSessionUpdateTask(this.client.getId()){

            @Override
            protected void runClientSessionUpdate(AuthenticatedClientSessionEntity entity) {
                entity.setRoles(roles);
            }
        };
        this.update(task);
    }

    public Set<String> getProtocolMappers() {
        return this.entity.getProtocolMappers();
    }

    public void setProtocolMappers(final Set<String> protocolMappers) {
        UserSessionClientSessionUpdateTask task = new UserSessionClientSessionUpdateTask(this.client.getId()){

            @Override
            protected void runClientSessionUpdate(AuthenticatedClientSessionEntity entity) {
                entity.setProtocolMappers(protocolMappers);
            }
        };
        this.update(task);
    }

    public String getNote(String name) {
        return this.entity.getNotes().get(name);
    }

    public void setNote(final String name, final String value) {
        UserSessionClientSessionUpdateTask task = new UserSessionClientSessionUpdateTask(this.client.getId()){

            @Override
            protected void runClientSessionUpdate(AuthenticatedClientSessionEntity entity) {
                entity.getNotes().put(name, value);
            }
        };
        this.update(task);
    }

    public void removeNote(final String name) {
        UserSessionClientSessionUpdateTask task = new UserSessionClientSessionUpdateTask(this.client.getId()){

            @Override
            protected void runClientSessionUpdate(AuthenticatedClientSessionEntity entity) {
                entity.getNotes().remove(name);
            }
        };
        this.update(task);
    }

    public Map<String, String> getNotes() {
        if (this.entity.getNotes().isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> copy = new HashMap<String, String>();
        copy.putAll(this.entity.getNotes());
        return copy;
    }
}

