/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes.sessions;

import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdateTask;
import org.keycloak.models.sessions.infinispan.changes.sessions.LastSessionRefreshStore;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;

public class LastSessionRefreshChecker {
    public static final Logger logger = Logger.getLogger(LastSessionRefreshChecker.class);
    private final LastSessionRefreshStore store;
    private final LastSessionRefreshStore offlineStore;

    public LastSessionRefreshChecker(LastSessionRefreshStore store, LastSessionRefreshStore offlineStore) {
        this.store = store;
        this.offlineStore = offlineStore;
    }

    public SessionUpdateTask.CrossDCMessageStatus getCrossDCMessageStatus(KeycloakSession kcSession, RealmModel realm, SessionEntityWrapper<UserSessionEntity> sessionWrapper, boolean offline, int newLastSessionRefresh) {
        int idleTimeout;
        LastSessionRefreshStore storeToUse;
        if (realm.isRevokeRefreshToken()) {
            return SessionUpdateTask.CrossDCMessageStatus.SYNC;
        }
        LastSessionRefreshStore lastSessionRefreshStore = storeToUse = offline ? this.offlineStore : this.store;
        if (storeToUse == null) {
            return SessionUpdateTask.CrossDCMessageStatus.SYNC;
        }
        Boolean ignoreRemoteCacheUpdate = (Boolean)kcSession.getAttribute("IGNORE_REMOTE_CACHE_UPDATE");
        if (ignoreRemoteCacheUpdate != null && ignoreRemoteCacheUpdate.booleanValue()) {
            return SessionUpdateTask.CrossDCMessageStatus.NOT_NEEDED;
        }
        Integer lsrr = sessionWrapper.getLocalMetadataNoteInt("lsrr");
        if (lsrr == null) {
            logger.debugf("Not available lsrr note on user session %s.", (Object)sessionWrapper.getEntity().getId());
            return SessionUpdateTask.CrossDCMessageStatus.SYNC;
        }
        int n = idleTimeout = offline ? realm.getOfflineSessionIdleTimeout() : realm.getSsoSessionIdleTimeout();
        if (lsrr + idleTimeout / 2 <= newLastSessionRefresh) {
            logger.debugf("We are going to write remotely. Remote last session refresh: %d, New last session refresh: %d", lsrr.intValue(), newLastSessionRefresh);
            return SessionUpdateTask.CrossDCMessageStatus.SYNC;
        }
        logger.debugf("Skip writing last session refresh to the remoteCache. Session %s newLastSessionRefresh %d", (Object)sessionWrapper.getEntity().getId(), (Object)newLastSessionRefresh);
        storeToUse.putLastSessionRefresh(kcSession, sessionWrapper.getEntity().getId(), realm.getId(), newLastSessionRefresh);
        return SessionUpdateTask.CrossDCMessageStatus.NOT_NEEDED;
    }
}

