/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.events;

import org.keycloak.cluster.ClusterEvent;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.sessions.infinispan.util.InfinispanUtil;

public abstract class SessionClusterEvent
implements ClusterEvent {
    private String realmId;
    private String eventKey;
    private boolean resendingEvent;
    private String siteId;
    private String nodeId;

    public static <T extends SessionClusterEvent> T createEvent(Class<T> eventClass, String eventKey, KeycloakSession session, String realmId, boolean resendingEvent) {
        try {
            SessionClusterEvent event = (SessionClusterEvent)eventClass.newInstance();
            event.setData(session, eventKey, realmId, resendingEvent);
            return (T)event;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void setData(KeycloakSession session, String eventKey, String realmId, boolean resendingEvent) {
        this.realmId = realmId;
        this.eventKey = eventKey;
        this.resendingEvent = resendingEvent;
        this.siteId = InfinispanUtil.getMySite(session);
        this.nodeId = InfinispanUtil.getMyAddress(session);
    }

    public String getRealmId() {
        return this.realmId;
    }

    public String getEventKey() {
        return this.eventKey;
    }

    public boolean isResendingEvent() {
        return this.resendingEvent;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String toString() {
        String simpleClassName = this.getClass().getSimpleName();
        return String.format("%s [ realmId=%s ]", simpleClassName, this.realmId);
    }
}

