/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.util.DoubleSummaryStatistics;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.NotSerializableException;
import org.infinispan.commons.util.Util;
import org.infinispan.marshall.exts.SecurityActions;

public class DoubleSummaryStatisticsExternalizer
extends AbstractExternalizer<DoubleSummaryStatistics> {
    static final Field countField = SecurityActions.getField(DoubleSummaryStatistics.class, "count");
    static final Field sumField = SecurityActions.getField(DoubleSummaryStatistics.class, "sum");
    static final Field sumCompensationField = SecurityActions.getField(DoubleSummaryStatistics.class, "sumCompensation");
    static final Field simpleSumField = SecurityActions.getField(DoubleSummaryStatistics.class, "simpleSum");
    static final Field minField = SecurityActions.getField(DoubleSummaryStatistics.class, "min");
    static final Field maxField = SecurityActions.getField(DoubleSummaryStatistics.class, "max");
    static final boolean canSerialize = countField != null && sumField != null && sumCompensationField != null && simpleSumField != null && minField != null && maxField != null;

    public Set<Class<? extends DoubleSummaryStatistics>> getTypeClasses() {
        return Util.asSet((Object[])new Class[]{DoubleSummaryStatistics.class});
    }

    private void verifySerialization() {
        if (!canSerialize) {
            throw new NotSerializableException("DoubleSummaryStatistics is not serializable, fields not available!");
        }
    }

    public void writeObject(ObjectOutput output, DoubleSummaryStatistics object) throws IOException {
        this.verifySerialization();
        try {
            output.writeLong(countField.getLong(object));
            output.writeDouble(sumField.getDouble(object));
            output.writeDouble(sumCompensationField.getDouble(object));
            output.writeDouble(simpleSumField.getDouble(object));
            output.writeDouble(minField.getDouble(object));
            output.writeDouble(maxField.getDouble(object));
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
    }

    public DoubleSummaryStatistics readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        this.verifySerialization();
        DoubleSummaryStatistics summaryStatistics = new DoubleSummaryStatistics();
        try {
            countField.setLong(summaryStatistics, input.readLong());
            sumField.setDouble(summaryStatistics, input.readDouble());
            sumCompensationField.setDouble(summaryStatistics, input.readDouble());
            simpleSumField.setDouble(summaryStatistics, input.readDouble());
            minField.setDouble(summaryStatistics, input.readDouble());
            maxField.setDouble(summaryStatistics, input.readDouble());
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
        return summaryStatistics;
    }

    public Integer getId() {
        return 23;
    }
}

