/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.impl;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.jmx.JmxStatisticsExposer;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.DisplayType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.jmx.annotations.Units;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.stats.CacheContainerStats;
import org.infinispan.stats.Stats;
import org.infinispan.util.TimeService;

@MBean(objectName="CacheContainerStats", description="General cache container statistics such as timings, hit/miss ratio, etc.")
public class CacheContainerStatsImpl
implements CacheContainerStats,
JmxStatisticsExposer {
    private EmbeddedCacheManager cm;
    private final AtomicLong resetNanoseconds = new AtomicLong(0L);
    private boolean statisticsEnabled = false;
    private TimeService timeService;

    public CacheContainerStatsImpl(EmbeddedCacheManager cm) {
        this.cm = cm;
        cm.getGlobalComponentRegistry().registerComponent((Object)this, CacheContainerStats.class);
        boolean globalJmxStatsEnabled = cm.getCacheManagerConfiguration().globalJmxStatistics().enabled();
        this.setStatisticsEnabled(globalJmxStatsEnabled);
    }

    @Inject
    public void setDependencies(TimeService timeService) {
        this.timeService = timeService;
    }

    @Override
    public void setStatisticsEnabled(boolean enabled) {
        this.statisticsEnabled = enabled;
        if (enabled) {
            this.resetNanoseconds.set(this.timeService.time());
        }
    }

    @Override
    public boolean getStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @Override
    public void resetStatistics() {
        if (this.getStatisticsEnabled()) {
            for (String cn : this.cm.getCacheNames()) {
                if (!this.cm.cacheExists(cn)) continue;
                this.cm.getCache(cn).getAdvancedCache().getStats().reset();
            }
            this.resetNanoseconds.set(this.timeService.time());
        }
    }

    @ManagedAttribute(description="Enables or disables the gathering of statistics by this component", displayName="Statistics enabled", dataType=DataType.TRAIT, writable=true)
    public boolean isStatisticsEnabled() {
        return this.getStatisticsEnabled();
    }

    @Override
    @ManagedAttribute(description="Cache container total average number of milliseconds for all read operation in this cache container", displayName="Cache container total average read time", units=Units.MILLISECONDS, displayType=DisplayType.SUMMARY)
    public long getAverageReadTime() {
        long result = -1L;
        if (this.getStatisticsEnabled()) {
            result = this.calculateAverageReadTime();
        }
        return result;
    }

    protected long calculateAverageReadTime() {
        long totalAverageReadTime = 0L;
        int includedCacheCounter = 0;
        for (String cn : this.cm.getCacheNames()) {
            long averageReadTime;
            if (!this.cm.cacheExists(cn) || (averageReadTime = this.cm.getCache(cn).getAdvancedCache().getStats().getAverageReadTime()) <= 0L) continue;
            ++includedCacheCounter;
            totalAverageReadTime += averageReadTime;
        }
        if (includedCacheCounter > 0) {
            totalAverageReadTime /= (long)includedCacheCounter;
        }
        return totalAverageReadTime;
    }

    @Override
    @ManagedAttribute(description="Cache container total average number of milliseconds for all remove operation in this cache container", displayName="Cache container total average remove time", units=Units.MILLISECONDS, displayType=DisplayType.SUMMARY)
    public long getAverageRemoveTime() {
        long result = -1L;
        if (this.getStatisticsEnabled()) {
            result = this.calculateAverageRemoveTime();
        }
        return result;
    }

    protected long calculateAverageRemoveTime() {
        long totalAverageRemoveTime = 0L;
        int includedCacheCounter = 0;
        for (String cn : this.cm.getCacheNames()) {
            long averageRemoveTime;
            if (!this.cm.cacheExists(cn) || (averageRemoveTime = this.cm.getCache(cn).getAdvancedCache().getStats().getAverageRemoveTime()) <= 0L) continue;
            ++includedCacheCounter;
            totalAverageRemoveTime += averageRemoveTime;
        }
        if (includedCacheCounter > 0) {
            totalAverageRemoveTime /= (long)includedCacheCounter;
        }
        return totalAverageRemoveTime;
    }

    @Override
    @ManagedAttribute(description="Cache container average number of milliseconds for all write operation in this cache container", displayName="Cache container average write time", units=Units.MILLISECONDS, displayType=DisplayType.SUMMARY)
    public long getAverageWriteTime() {
        long result = -1L;
        if (this.getStatisticsEnabled()) {
            result = this.calculateAverageWriteTime();
        }
        return result;
    }

    protected long calculateAverageWriteTime() {
        long totalAverageWriteTime = 0L;
        int includedCacheCounter = 0;
        for (String cn : this.cm.getCacheNames()) {
            long averageWriteTime;
            if (!this.cm.cacheExists(cn) || (averageWriteTime = this.cm.getCache(cn).getAdvancedCache().getStats().getAverageWriteTime()) <= 0L) continue;
            ++includedCacheCounter;
            totalAverageWriteTime += averageWriteTime;
        }
        if (includedCacheCounter > 0) {
            totalAverageWriteTime /= (long)includedCacheCounter;
        }
        return totalAverageWriteTime;
    }

    @Override
    @ManagedAttribute(description="Cache container total number of cache eviction operations", displayName="Cache container total number of cache evictions", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getEvictions() {
        long result = -1L;
        if (this.getStatisticsEnabled()) {
            result = this.calculateEvictions();
        }
        return result;
    }

    protected long calculateEvictions() {
        long totalEvictions = 0L;
        for (String cn : this.cm.getCacheNames()) {
            long evictions;
            if (!this.cm.cacheExists(cn) || (evictions = this.cm.getCache(cn).getAdvancedCache().getStats().getEvictions()) <= 0L) continue;
            totalEvictions += evictions;
        }
        return totalEvictions;
    }

    @Override
    @ManagedAttribute(description="Cache container total number of cache attribute hits", displayName="Cache container total number of cache hits", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getHits() {
        long result = -1L;
        if (this.getStatisticsEnabled()) {
            result = this.calculateHits();
        }
        return result;
    }

    protected long calculateHits() {
        long totalHits = 0L;
        for (String cn : this.cm.getCacheNames()) {
            long hits;
            if (!this.cm.cacheExists(cn) || (hits = this.cm.getCache(cn).getAdvancedCache().getStats().getHits()) <= 0L) continue;
            totalHits += hits;
        }
        return totalHits;
    }

    @Override
    @ManagedAttribute(description="Cache container total percentage hit/(hit+miss) ratio for this cache", displayName="Cache container total hit ratio", units=Units.PERCENTAGE, displayType=DisplayType.SUMMARY)
    public double getHitRatio() {
        double result = -1.0;
        if (this.getStatisticsEnabled()) {
            result = this.calculateHitRatio();
        }
        return result;
    }

    protected double calculateHitRatio() {
        long totalHits = 0L;
        double totalRequests = 0.0;
        double rwRatio = 0.0;
        for (String cn : this.cm.getCacheNames()) {
            Stats stats;
            long requests;
            if (!this.cm.cacheExists(cn) || (requests = (stats = this.cm.getCache(cn).getAdvancedCache().getStats()).getRetrievals()) <= 0L) continue;
            totalHits += stats.getHits();
            totalRequests += (double)requests;
        }
        if (totalRequests > 0.0) {
            rwRatio = (double)totalHits / totalRequests;
        }
        return rwRatio;
    }

    @Override
    @ManagedAttribute(description="Cache container total number of cache attribute misses", displayName="Cache container total number of cache misses", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getMisses() {
        long result = -1L;
        if (this.getStatisticsEnabled()) {
            result = this.calculateMisses();
        }
        return result;
    }

    protected long calculateMisses() {
        long totalMisess = 0L;
        for (String cn : this.cm.getCacheNames()) {
            long misses;
            if (!this.cm.cacheExists(cn) || (misses = this.cm.getCache(cn).getAdvancedCache().getStats().getMisses()) <= 0L) continue;
            totalMisess += misses;
        }
        return totalMisess;
    }

    @ManagedAttribute(description="Cache container total number of entries currently in all caches from this cache container", displayName="Cache container total number of all cache entries", displayType=DisplayType.SUMMARY)
    public int getNumberOfEntries() {
        int result = -1;
        if (this.getStatisticsEnabled()) {
            result = this.calculateNumberOfEntries();
        }
        return result;
    }

    protected int calculateNumberOfEntries() {
        int totalNumberOfEntries = 0;
        for (String cn : this.cm.getCacheNames()) {
            int numOfEntries;
            if (!this.cm.cacheExists(cn) || (numOfEntries = this.cm.getCache(cn).getAdvancedCache().getStats().getCurrentNumberOfEntries()) <= 0) continue;
            totalNumberOfEntries += numOfEntries;
        }
        return totalNumberOfEntries;
    }

    @Override
    @ManagedAttribute(description="Cache container read/writes ratio in all caches from this cache container", displayName="Cache container read/write ratio", units=Units.PERCENTAGE, displayType=DisplayType.SUMMARY)
    public double getReadWriteRatio() {
        double result = -1.0;
        if (this.getStatisticsEnabled()) {
            result = this.calculateReadWriteRatio();
        }
        return result;
    }

    protected double calculateReadWriteRatio() {
        long sumOfAllReads = 0L;
        long sumOfAllWrites = 0L;
        double rwRatio = 0.0;
        for (String cn : this.cm.getCacheNames()) {
            Stats stats;
            long stores;
            if (!this.cm.cacheExists(cn) || (stores = (stats = this.cm.getCache(cn).getAdvancedCache().getStats()).getStores()) <= 0L) continue;
            sumOfAllReads += stats.getRetrievals();
            sumOfAllWrites += stores;
        }
        if (sumOfAllWrites > 0L) {
            rwRatio = (double)sumOfAllReads / (double)sumOfAllWrites;
        }
        return rwRatio;
    }

    @Override
    @ManagedAttribute(description="Cache container total number of cache removal hits", displayName="Cache container total number of cache removal hits", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getRemoveHits() {
        long result = -1L;
        if (this.getStatisticsEnabled()) {
            result = this.calculateRemoveHits();
        }
        return result;
    }

    protected long calculateRemoveHits() {
        long totalRemoveHits = 0L;
        for (String cn : this.cm.getCacheNames()) {
            long removeHits;
            if (!this.cm.cacheExists(cn) || (removeHits = this.cm.getCache(cn).getAdvancedCache().getStats().getRemoveHits()) <= 0L) continue;
            totalRemoveHits += removeHits;
        }
        return totalRemoveHits;
    }

    @Override
    @ManagedAttribute(description="Cache container total number of cache removals where keys were not found", displayName="Cache container total number of cache removal misses", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getRemoveMisses() {
        long result = -1L;
        if (this.getStatisticsEnabled()) {
            result = this.calculateRemoveMisses();
        }
        return result;
    }

    protected long calculateRemoveMisses() {
        long totalRemoveMisses = 0L;
        for (String cn : this.cm.getCacheNames()) {
            long removeMisses;
            if (!this.cm.cacheExists(cn) || (removeMisses = this.cm.getCache(cn).getAdvancedCache().getStats().getRemoveMisses()) <= 0L) continue;
            totalRemoveMisses += removeMisses;
        }
        return totalRemoveMisses;
    }

    @Override
    @ManagedAttribute(description="Cache container total number of cache attribute put operations", displayName="Cache container total number of cache puts", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getStores() {
        long result = -1L;
        if (this.getStatisticsEnabled()) {
            result = this.calculateStores();
        }
        return result;
    }

    @Override
    @ManagedAttribute(description="Number of seconds since the cache container statistics were last reset", displayName="Seconds since cache container statistics were reset", units=Units.SECONDS, displayType=DisplayType.SUMMARY)
    public long getTimeSinceReset() {
        long result = -1L;
        if (this.getStatisticsEnabled()) {
            result = this.timeService.timeDuration(this.resetNanoseconds.get(), TimeUnit.SECONDS);
        }
        return result;
    }

    protected long calculateStores() {
        long totalStores = 0L;
        for (String cn : this.cm.getCacheNames()) {
            long stores;
            if (!this.cm.cacheExists(cn) || (stores = this.cm.getCache(cn).getAdvancedCache().getStats().getStores()) <= 0L) continue;
            totalStores += stores;
        }
        return totalStores;
    }

    @Override
    public long getTimeSinceStart() {
        long result = -1L;
        if (this.getStatisticsEnabled()) {
            result = this.calculateTimeSinceStart();
        }
        return result;
    }

    protected long calculateTimeSinceStart() {
        long longestRunning = 0L;
        for (String cn : this.cm.getCacheNames()) {
            long runningTime;
            if (!this.cm.cacheExists(cn) || (runningTime = this.cm.getCache(cn).getAdvancedCache().getStats().getTimeSinceStart()) <= longestRunning) continue;
            longestRunning = runningTime;
        }
        return longestRunning;
    }

    @Override
    public int getCurrentNumberOfEntries() {
        return this.getNumberOfEntries();
    }

    @Override
    public long getTotalNumberOfEntries() {
        return this.getStores();
    }

    @Override
    public long getRetrievals() {
        return this.getHits() + this.getMisses();
    }

    @Override
    public void reset() {
        this.resetStatistics();
    }
}

