/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.net.URI;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.jboss.ejb.client.AbstractInvocationContext;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.ClusterAffinity;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBRootContext;
import org.jboss.ejb.client.EJBSessionCreationInvocationContext;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.annotation.ClientInterceptorPriority;
import org.wildfly.naming.client.NamingProvider;

@ClientInterceptorPriority(value=200050)
public final class NamingEJBClientInterceptor
implements EJBClientInterceptor {
    public static final int PRIORITY = 200050;

    @Override
    public void handleInvocation(EJBClientInvocationContext context) throws Exception {
        NamingEJBClientInterceptor.setDestination(context, context.getProxyAttachment(EJBRootContext.NAMING_PROVIDER_ATTACHMENT_KEY));
        context.sendRequest();
    }

    @Override
    public Object handleInvocationResult(EJBClientInvocationContext context) throws Exception {
        return context.getResult();
    }

    @Override
    public SessionID handleSessionCreation(EJBSessionCreationInvocationContext context) throws Exception {
        NamingEJBClientInterceptor.setDestination(context, context.getAttachment(EJBRootContext.NAMING_PROVIDER_ATTACHMENT_KEY));
        return context.proceed();
    }

    private static void setDestination(AbstractInvocationContext context, NamingProvider namingProvider) {
        Affinity weakAffinity;
        EJBLocator<?> locator;
        URI destination;
        if (namingProvider != null && (destination = context.getDestination()) == null && ((locator = context.getLocator()).getAffinity() == Affinity.NONE || locator.getAffinity() instanceof ClusterAffinity) && ((weakAffinity = context.getWeakAffinity()) == Affinity.NONE || weakAffinity instanceof ClusterAffinity)) {
            List<NamingProvider.Location> locations = namingProvider.getLocations();
            if (locations.size() == 1) {
                context.setDestination(locations.get(0).getUri());
            } else if (locations.size() > 0) {
                context.setDestination(locations.get(ThreadLocalRandom.current().nextInt(locations.size())).getUri());
            }
        }
    }
}

