/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store.impl;

import java.io.Serializable;
import java.util.Properties;
import org.apache.lucene.document.Document;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.filter.FullTextFilterImplementor;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.store.IndexShardingStrategy;

public class NotShardedStrategy
implements IndexShardingStrategy {
    private IndexManager[] directoryProvider;

    @Override
    public void initialize(Properties properties, IndexManager[] indexManagers) {
        this.directoryProvider = indexManagers;
        if (this.directoryProvider.length > 1) {
            throw new AssertionFailure("Using SingleDirectoryProviderSelectionStrategy with multiple DirectoryProviders");
        }
    }

    @Override
    public IndexManager[] getIndexManagersForAllShards() {
        return this.directoryProvider;
    }

    @Override
    public IndexManager getIndexManagerForAddition(Class<?> entity, Serializable id, String idInString, Document document) {
        return this.directoryProvider[0];
    }

    @Override
    public IndexManager[] getIndexManagersForDeletion(Class<?> entity, Serializable id, String idInString) {
        return this.directoryProvider;
    }

    @Override
    public IndexManager[] getIndexManagersForQuery(FullTextFilterImplementor[] fullTextFilters) {
        return this.directoryProvider;
    }
}

