/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;
import org.apache.activemq.artemis.reader.BytesMessageUtil;

public class ActiveMQBytesMessage
extends ActiveMQMessage
implements BytesMessage {
    public static final byte TYPE = 4;
    private int bodyLength;

    protected ActiveMQBytesMessage(ClientSession session) {
        super((byte)4, session);
    }

    protected ActiveMQBytesMessage(ClientMessage message, ClientSession session) {
        super(message, session);
    }

    public ActiveMQBytesMessage(BytesMessage foreign, ClientSession session) throws JMSException {
        super(foreign, (byte)4, session);
        foreign.reset();
        byte[] buffer = new byte[1024];
        int n = foreign.readBytes(buffer);
        while (n != -1) {
            this.writeBytes(buffer, 0, n);
            n = foreign.readBytes(buffer);
        }
    }

    @Override
    public boolean readBoolean() throws JMSException {
        this.checkRead();
        try {
            return BytesMessageUtil.bytesReadBoolean(this.message.getBodyBuffer());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    @Override
    public byte readByte() throws JMSException {
        this.checkRead();
        try {
            return BytesMessageUtil.bytesReadByte(this.message.getBodyBuffer());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    @Override
    public int readUnsignedByte() throws JMSException {
        this.checkRead();
        try {
            return BytesMessageUtil.bytesReadUnsignedByte(this.message.getBodyBuffer());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    @Override
    public short readShort() throws JMSException {
        this.checkRead();
        try {
            return BytesMessageUtil.bytesReadShort(this.message.getBodyBuffer());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    @Override
    public int readUnsignedShort() throws JMSException {
        this.checkRead();
        try {
            return BytesMessageUtil.bytesReadUnsignedShort(this.message.getBodyBuffer());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    @Override
    public char readChar() throws JMSException {
        this.checkRead();
        try {
            return BytesMessageUtil.bytesReadChar(this.message.getBodyBuffer());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    @Override
    public int readInt() throws JMSException {
        this.checkRead();
        try {
            return BytesMessageUtil.bytesReadInt(this.message.getBodyBuffer());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    @Override
    public long readLong() throws JMSException {
        this.checkRead();
        try {
            return BytesMessageUtil.bytesReadLong(this.message.getBodyBuffer());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    @Override
    public float readFloat() throws JMSException {
        this.checkRead();
        try {
            return BytesMessageUtil.bytesReadFloat(this.message.getBodyBuffer());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    @Override
    public double readDouble() throws JMSException {
        this.checkRead();
        try {
            return BytesMessageUtil.bytesReadDouble(this.message.getBodyBuffer());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
    }

    @Override
    public String readUTF() throws JMSException {
        this.checkRead();
        try {
            return BytesMessageUtil.bytesReadUTF(this.message.getBodyBuffer());
        }
        catch (IndexOutOfBoundsException e) {
            throw new MessageEOFException("");
        }
        catch (Exception e) {
            JMSException je = new JMSException("Failed to get UTF");
            je.setLinkedException(e);
            je.initCause(e);
            throw je;
        }
    }

    @Override
    public int readBytes(byte[] value) throws JMSException {
        this.checkRead();
        return BytesMessageUtil.bytesReadBytes(this.message.getBodyBuffer(), value);
    }

    @Override
    public int readBytes(byte[] value, int length) throws JMSException {
        this.checkRead();
        return BytesMessageUtil.bytesReadBytes(this.message.getBodyBuffer(), value, length);
    }

    @Override
    public void writeBoolean(boolean value) throws JMSException {
        this.checkWrite();
        BytesMessageUtil.bytesWriteBoolean(this.message.getBodyBuffer(), value);
    }

    @Override
    public void writeByte(byte value) throws JMSException {
        this.checkWrite();
        BytesMessageUtil.bytesWriteByte(this.message.getBodyBuffer(), value);
    }

    @Override
    public void writeShort(short value) throws JMSException {
        this.checkWrite();
        BytesMessageUtil.bytesWriteShort(this.message.getBodyBuffer(), value);
    }

    @Override
    public void writeChar(char value) throws JMSException {
        this.checkWrite();
        BytesMessageUtil.bytesWriteChar(this.message.getBodyBuffer(), value);
    }

    @Override
    public void writeInt(int value) throws JMSException {
        this.checkWrite();
        BytesMessageUtil.bytesWriteInt(this.message.getBodyBuffer(), value);
    }

    @Override
    public void writeLong(long value) throws JMSException {
        this.checkWrite();
        BytesMessageUtil.bytesWriteLong(this.message.getBodyBuffer(), value);
    }

    @Override
    public void writeFloat(float value) throws JMSException {
        this.checkWrite();
        BytesMessageUtil.bytesWriteFloat(this.message.getBodyBuffer(), value);
    }

    @Override
    public void writeDouble(double value) throws JMSException {
        this.checkWrite();
        BytesMessageUtil.bytesWriteDouble(this.message.getBodyBuffer(), value);
    }

    @Override
    public void writeUTF(String value) throws JMSException {
        this.checkWrite();
        try {
            BytesMessageUtil.bytesWriteUTF(this.message.getBodyBuffer(), value);
        }
        catch (Exception e) {
            JMSException je = new JMSException("Failed to write UTF");
            je.setLinkedException(e);
            je.initCause(e);
            throw je;
        }
    }

    @Override
    public void writeBytes(byte[] value) throws JMSException {
        this.checkWrite();
        BytesMessageUtil.bytesWriteBytes(this.message.getBodyBuffer(), value);
    }

    @Override
    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.checkWrite();
        BytesMessageUtil.bytesWriteBytes(this.message.getBodyBuffer(), value, offset, length);
    }

    @Override
    public void writeObject(Object value) throws JMSException {
        this.checkWrite();
        if (!BytesMessageUtil.bytesWriteObject(this.message.getBodyBuffer(), value)) {
            throw new MessageFormatException("Invalid object for properties");
        }
    }

    @Override
    public void reset() throws JMSException {
        if (!this.readOnly) {
            this.readOnly = true;
            this.bodyLength = this.message.getBodySize();
        }
        BytesMessageUtil.bytesMessageReset(this.message.getBodyBuffer());
    }

    @Override
    public void doBeforeReceive() throws ActiveMQException {
        this.bodyLength = this.message.getBodySize();
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        try {
            this.getBuffer().clear();
        }
        catch (RuntimeException e) {
            JMSException e2 = new JMSException(e.getMessage());
            e2.initCause(e);
            throw e2;
        }
    }

    @Override
    public long getBodyLength() throws JMSException {
        this.checkRead();
        return this.bodyLength;
    }

    @Override
    public void doBeforeSend() throws Exception {
        this.reset();
    }

    @Override
    public byte getType() {
        return 4;
    }

    private ActiveMQBuffer getBuffer() {
        return this.message.getBodyBuffer();
    }

    @Override
    public boolean isBodyAssignableTo(Class c) {
        return c.isAssignableFrom(byte[].class);
    }

    @Override
    protected <T> T getBodyInternal(Class<T> c) {
        if (this.bodyLength == 0) {
            return null;
        }
        byte[] dst = new byte[this.bodyLength];
        this.message.getBodyBuffer().getBytes(17, dst);
        return (T)dst;
    }
}

