/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms.uri;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.jms.ConnectionFactory;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.jms.uri.JMSEndpointWSDLUtil;
import org.apache.cxf.transport.jms.uri.JMSURIParser;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

public class JMSEndpoint {
    public static final String JNDI = "jndi";
    public static final String TOPIC = "topic";
    public static final String QUEUE = "queue";
    public static final String JNDI_TOPIC = "jndi-topic";
    public static final DeliveryModeType DELIVERYMODE_DEFAULT = DeliveryModeType.PERSISTENT;
    public static final long TIMETOLIVE_DEFAULT = 0L;
    public static final int PRIORITY_DEFAULT = 4;
    public static final String JNDI_PARAMETER_NAME_PREFIX = "jndi-";
    public static final String JAXWS_PROPERTY_PREFIX = "jms.";
    private Map<String, String> jndiParameters = new HashMap<String, String>();
    private Map<String, String> parameters = new HashMap<String, String>();
    private String endpointUri;
    private ConnectionFactory connectionFactory;
    private String jmsVariant = "queue";
    private String destinationName;
    private String conduitIdSelectorPrefix;
    private DeliveryModeType deliveryMode;
    private String durableSubscriptionClientId;
    private String durableSubscriptionName;
    private String jndiConnectionFactoryName = "ConnectionFactory";
    private String jndiInitialContextFactory;
    private String jndiTransactionManagerName;
    private String jndiURL;
    private MessageType messageType;
    private String password;
    private Integer priority;
    private long receiveTimeout = 60000L;
    private String replyToName;
    private boolean sessionTransacted;
    private String targetService;
    private long timeToLive;
    private String topicReplyToName;
    private boolean useConduitIdSelector = true;
    private String username;
    private int concurrentConsumers = 1;
    private String messageSelector;

    public JMSEndpoint(String endpointUri) {
        this(null, endpointUri);
    }

    public JMSEndpoint(EndpointInfo endpointInfo, EndpointReferenceType target) {
        this(endpointInfo, target == null ? endpointInfo.getAddress() : target.getAddress().getValue());
    }

    public JMSEndpoint(EndpointInfo ei, String endpointUri) {
        if (ei != null) {
            JMSEndpointWSDLUtil.retrieveWSDLInformation(this, ei);
        }
        if (!StringUtils.isEmpty((String)endpointUri) && !"jms://".equals(endpointUri) && endpointUri.startsWith("jms")) {
            this.endpointUri = endpointUri;
            JMSURIParser parsed = new JMSURIParser(endpointUri);
            this.setJmsVariant(parsed.getVariant());
            this.destinationName = parsed.getDestination();
            Map<String, Object> query = parsed.parseQuery();
            this.configureProperties(query);
            HashMap<String, Object> jmsProps = new HashMap<String, Object>();
            if (ei != null) {
                this.getJaxWsJmsProps(ei.getProperties(), jmsProps);
            }
            if (ei != null && ei.getBinding() != null) {
                this.getJaxWsJmsProps(ei.getBinding().getProperties(), jmsProps);
            }
            this.configureProperties(jmsProps);
        }
    }

    private void getJaxWsJmsProps(Map<String, Object> jaxwsProps, Map<String, Object> jmsProps) {
        if (jaxwsProps == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : jaxwsProps.entrySet()) {
            if (!entry.getKey().startsWith(JAXWS_PROPERTY_PREFIX)) continue;
            jmsProps.put(entry.getKey().substring(JAXWS_PROPERTY_PREFIX.length()), entry.getValue());
        }
    }

    private boolean trySetProperty(String name, Object value) {
        try {
            Method method = this.getClass().getMethod(this.getPropSetterName(name), value.getClass());
            method.invoke((Object)this, value);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException("Error setting property " + name + ":" + e.getMessage(), e);
        }
    }

    private String getPropSetterName(String name) {
        String first = name.substring(0, 1);
        String rest = name.substring(1);
        return "set" + first.toUpperCase() + rest;
    }

    private void configureProperties(Map<String, Object> params) {
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key;
            Object value = entry.getValue();
            if (value == null || value.equals("") || this.trySetProperty(key = entry.getKey(), value) || !(value instanceof String)) continue;
            String valueSt = (String)value;
            if (key.startsWith(JNDI_PARAMETER_NAME_PREFIX)) {
                key = key.substring(5);
                this.putJndiParameter(key, valueSt);
                continue;
            }
            this.putParameter(key, valueSt);
        }
        if (this.replyToName != null && this.topicReplyToName != null) {
            throw new IllegalArgumentException("The replyToName and topicReplyToName should not be defined at the same time.");
        }
    }

    public String getRequestURI() {
        StringBuilder requestUri = new StringBuilder("jms:");
        if (this.jmsVariant == JNDI_TOPIC) {
            requestUri.append(JNDI);
        } else {
            requestUri.append(this.jmsVariant);
        }
        requestUri.append(":" + this.destinationName);
        boolean first = true;
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            String value = entry.getValue();
            if (first) {
                requestUri.append("?" + entry.getKey() + "=" + value);
                first = false;
                continue;
            }
            requestUri.append("&" + entry.getKey() + "=" + value);
        }
        return requestUri.toString();
    }

    public void putJndiParameter(String key, String value) {
        this.jndiParameters.put(key, value);
    }

    public void putParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public String getParameter(String key) {
        return this.parameters.get(key);
    }

    public Map<String, String> getJndiParameters() {
        return this.jndiParameters;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getEndpointUri() {
        return this.endpointUri;
    }

    public void setEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public String getJmsVariant() {
        return this.jmsVariant;
    }

    public void setJmsVariant(String jmsVariant) {
        if (jmsVariant == null) {
            this.jmsVariant = QUEUE;
        }
        if (!(QUEUE.equals(jmsVariant) || TOPIC.equals(jmsVariant) || JNDI.equals(jmsVariant) || JNDI_TOPIC.equals(jmsVariant))) {
            throw new IllegalArgumentException("Unknow JMS Variant " + jmsVariant);
        }
        this.jmsVariant = jmsVariant;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public boolean isSetDeliveryMode() {
        return this.deliveryMode != null;
    }

    public DeliveryModeType getDeliveryMode() {
        return this.deliveryMode == null ? DeliveryModeType.PERSISTENT : this.deliveryMode;
    }

    public void setDeliveryMode(DeliveryModeType deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public void setDeliveryMode(String deliveryMode) {
        this.deliveryMode = DeliveryModeType.valueOf(deliveryMode);
    }

    public MessageType getMessageType() {
        return this.messageType == null ? MessageType.BYTE : this.messageType;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = MessageType.fromValue(messageType);
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public void setTimeToLive(String timeToLive) {
        this.timeToLive = Long.parseLong(timeToLive);
    }

    public boolean isSetPriority() {
        return this.priority != null;
    }

    public int getPriority() {
        return this.priority == null ? 4 : this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setPriority(String priority) {
        this.priority = Integer.valueOf(priority);
    }

    public String getReplyToName() {
        return this.replyToName;
    }

    public void setReplyToName(String replyToName) {
        this.replyToName = replyToName;
    }

    public String getTopicReplyToName() {
        return this.topicReplyToName;
    }

    public void setTopicReplyToName(String topicReplyToName) {
        this.topicReplyToName = topicReplyToName;
    }

    public String getJndiConnectionFactoryName() {
        return this.jndiConnectionFactoryName;
    }

    public void setJndiConnectionFactoryName(String jndiConnectionFactoryName) {
        this.jndiConnectionFactoryName = jndiConnectionFactoryName;
    }

    public String getJndiInitialContextFactory() {
        return this.jndiInitialContextFactory;
    }

    public void setJndiInitialContextFactory(String jndiInitialContextFactory) {
        this.jndiInitialContextFactory = jndiInitialContextFactory;
    }

    public String getJndiURL() {
        return this.jndiURL;
    }

    public void setJndiURL(String jndiURL) {
        this.jndiURL = jndiURL;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public int getConcurrentConsumers() {
        return this.concurrentConsumers;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public void setConcurrentConsumers(String concurrentConsumers) {
        this.concurrentConsumers = Integer.parseInt(concurrentConsumers);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDurableSubscriptionClientId() {
        return this.durableSubscriptionClientId;
    }

    public void setDurableSubscriptionClientId(String durableSubscriptionClientId) {
        this.durableSubscriptionClientId = durableSubscriptionClientId;
    }

    public String getDurableSubscriptionName() {
        return this.durableSubscriptionName;
    }

    public void setDurableSubscriptionName(String durableSubscriptionName) {
        this.durableSubscriptionName = durableSubscriptionName;
    }

    public long getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public void setReceiveTimeout(String receiveTimeout) {
        this.receiveTimeout = Long.parseLong(receiveTimeout);
    }

    public String getTargetService() {
        return this.targetService;
    }

    public void setTargetService(String targetService) {
        this.targetService = targetService;
    }

    public boolean isSessionTransacted() {
        return this.sessionTransacted;
    }

    public void setSessionTransacted(boolean sessionTransacted) {
        this.sessionTransacted = sessionTransacted;
    }

    public void setSessionTransacted(String sessionTransacted) {
        this.sessionTransacted = Boolean.valueOf(sessionTransacted);
    }

    public String getConduitIdSelectorPrefix() {
        return this.conduitIdSelectorPrefix;
    }

    public void setConduitIdSelectorPrefix(String conduitIdSelectorPrefix) {
        this.conduitIdSelectorPrefix = conduitIdSelectorPrefix;
    }

    public boolean isUseConduitIdSelector() {
        return this.useConduitIdSelector;
    }

    public void setUseConduitIdSelector(String useConduitIdSelectorSt) {
        this.useConduitIdSelector = Boolean.valueOf(useConduitIdSelectorSt);
    }

    public void setUseConduitIdSelector(boolean useConduitIdSelector) {
        this.useConduitIdSelector = useConduitIdSelector;
    }

    public String getJndiTransactionManagerName() {
        return this.jndiTransactionManagerName;
    }

    public void setJndiTransactionManagerName(String jndiTransactionManagerName) {
        this.jndiTransactionManagerName = jndiTransactionManagerName;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public static enum MessageType {
        BYTE("byte"),
        BINARY("binary"),
        TEXT("text");

        private final String value;

        private MessageType(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static MessageType fromValue(String v) {
            for (MessageType c : MessageType.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }

    public static enum DeliveryModeType {
        PERSISTENT,
        NON_PERSISTENT;

    }
}

