/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.locators.attrib;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import org.jboss.security.xacml.jaxb.Option;
import org.jboss.security.xacml.locators.attrib.StorageAttributeLocator;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.jboss.security.xacml.sunxacml.attr.BagAttribute;
import org.jboss.security.xacml.sunxacml.cond.EvaluationResult;
import org.jboss.security.xacml.util.JBossXACMLUtil;
import org.jboss.security.xacml.util.LDAPCommon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LDAPAttributeLocator
extends StorageAttributeLocator {
    private static Logger log = Logger.getLogger(LDAPAttributeLocator.class.getName());
    protected LDAPCommon ldapCommon = new LDAPCommon();

    public LDAPAttributeLocator() {
        this.attributeDesignatorSupported = true;
        this.attributeSelectorSupported = true;
        this.designatorTypes.add(0);
        this.designatorTypes.add(1);
        this.designatorTypes.add(2);
    }

    @Override
    public void setOptions(List<Option> theoptions) {
        super.setOptions(theoptions);
        this.ldapCommon.processOptions(theoptions);
        this.ldapCommon.validateConfiguration(LDAPCommon.TYPE.ATTRIBUTE);
    }

    @Override
    public EvaluationResult findAttribute(URI attributeType, URI attributeId, URI issuer, URI subjectCategory, EvaluationCtx context, int designatorType) {
        if (!this.ids.contains(attributeId)) {
            if (attributeType != null) {
                return new EvaluationResult(BagAttribute.createEmptyBag(attributeType));
            }
            return new EvaluationResult(BagAttribute.createEmptyBag(attributeId));
        }
        this.dataTypeOfSubstituteValue = this.ldapCommon.getDataTypeOfSubstituteValue();
        this.substituteValue = this.ldapCommon.getSubsititeValue();
        Object columnValue = null;
        try {
            columnValue = this.getSubstituteValue(attributeType, context);
        }
        catch (URISyntaxException e) {
            log.log(Level.SEVERE, "Syntax error in uri:", e);
        }
        Object[] filterArgs = new Object[]{columnValue};
        NamingEnumeration<SearchResult> results = null;
        try {
            this.ldapCommon.constructJNDIContext();
            results = this.ldapCommon.search(filterArgs);
            while (results.hasMore()) {
                Attribute ldapAttribute;
                SearchResult rs = results.next();
                Attributes attributes = rs.getAttributes();
                if (attributes == null || (ldapAttribute = attributes.get(this.ldapCommon.getLdapAttribute())) == null) continue;
                this.attributeValue = ldapAttribute.get();
            }
        }
        catch (NamingException e) {
            log.severe(e.getMessage());
            throw new IllegalStateException(e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (NamingException ignore) {}
            }
            try {
                this.ldapCommon.closeJNDIContext();
            }
            catch (NamingException ignore) {}
        }
        HashSet<AttributeValue> bagSet = new HashSet<AttributeValue>();
        bagSet.add(JBossXACMLUtil.getAttributeValue(this.attributeValue));
        return new EvaluationResult(new BagAttribute(attributeType, bagSet));
    }

    @Override
    protected void usePassedOption(String optionTag, String optionValue) {
        super.usePassedOption(optionTag, optionValue);
        this.ldapCommon.processPassedOption(optionTag, optionValue);
    }
}

