/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.saml.v2.factories;

import java.net.URI;
import javax.xml.datatype.XMLGregorianCalendar;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.BaseIDAbstractType;
import org.keycloak.dom.saml.v2.assertion.EncryptedAssertionType;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.assertion.SubjectConfirmationDataType;
import org.keycloak.dom.saml.v2.assertion.SubjectConfirmationType;
import org.keycloak.dom.saml.v2.assertion.SubjectType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.dom.saml.v2.protocol.StatusCodeType;
import org.keycloak.dom.saml.v2.protocol.StatusType;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.processing.core.saml.v2.common.IDGenerator;
import org.keycloak.saml.processing.core.saml.v2.factories.SAMLAssertionFactory;
import org.keycloak.saml.processing.core.saml.v2.holders.IDPInfoHolder;
import org.keycloak.saml.processing.core.saml.v2.holders.IssuerInfoHolder;
import org.keycloak.saml.processing.core.saml.v2.holders.SPInfoHolder;
import org.keycloak.saml.processing.core.saml.v2.util.XMLTimeUtil;
import org.w3c.dom.Element;

public class JBossSAMLAuthnResponseFactory {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public static StatusType createStatusType(String statusCodeURI) {
        StatusCodeType sct = new StatusCodeType();
        sct.setValue(URI.create(statusCodeURI));
        StatusType statusType = new StatusType();
        statusType.setStatusCode(sct);
        return statusType;
    }

    public static StatusType createStatusTypeForResponder(String statusCodeURI) {
        StatusCodeType topLevelCode = new StatusCodeType();
        topLevelCode.setValue(URI.create(JBossSAMLURIConstants.STATUS_RESPONDER.get()));
        StatusCodeType secondLevelCode = new StatusCodeType();
        secondLevelCode.setValue(URI.create(statusCodeURI));
        topLevelCode.setStatusCode(secondLevelCode);
        StatusType statusType = new StatusType();
        statusType.setStatusCode(topLevelCode);
        return statusType;
    }

    public static ResponseType createResponseType(String ID, SPInfoHolder sp, IDPInfoHolder idp, IssuerInfoHolder issuerInfo) throws ConfigurationException {
        String responseDestinationURI = sp.getResponseDestinationURI();
        XMLGregorianCalendar issueInstant = XMLTimeUtil.getIssueInstant();
        String id = IDGenerator.create("ID_");
        SubjectType subjectType = new SubjectType();
        NameIDType nameIDType = new NameIDType();
        nameIDType.setFormat(URI.create(idp.getNameIDFormat()));
        nameIDType.setValue(idp.getNameIDFormatValue());
        SubjectType.STSubType subType = new SubjectType.STSubType();
        subType.addBaseID((BaseIDAbstractType)nameIDType);
        subjectType.setSubType(subType);
        SubjectConfirmationType subjectConfirmation = new SubjectConfirmationType();
        subjectConfirmation.setMethod(idp.getSubjectConfirmationMethod());
        SubjectConfirmationDataType subjectConfirmationData = new SubjectConfirmationDataType();
        subjectConfirmationData.setInResponseTo(sp.getRequestID());
        subjectConfirmationData.setRecipient(responseDestinationURI);
        subjectConfirmationData.setNotOnOrAfter(issueInstant);
        subjectConfirmation.setSubjectConfirmationData(subjectConfirmationData);
        subjectType.addConfirmation(subjectConfirmation);
        AssertionType assertionType = SAMLAssertionFactory.createAssertion(id, nameIDType, issueInstant, null, subjectType, null);
        ResponseType responseType = JBossSAMLAuthnResponseFactory.createResponseType(ID, issuerInfo, assertionType);
        responseType.setInResponseTo(sp.getRequestID());
        responseType.setDestination(responseDestinationURI);
        return responseType;
    }

    public static ResponseType createResponseType(String ID, IssuerInfoHolder issuerInfo, AssertionType assertionType) throws ConfigurationException {
        XMLGregorianCalendar issueInstant = XMLTimeUtil.getIssueInstant();
        ResponseType responseType = new ResponseType(ID, issueInstant);
        NameIDType issuer = issuerInfo.getIssuer();
        responseType.setIssuer(issuer);
        String statusCode = issuerInfo.getStatusCode();
        if (statusCode == null) {
            throw logger.issuerInfoMissingStatusCodeError();
        }
        responseType.setStatus(JBossSAMLAuthnResponseFactory.createStatusType(statusCode));
        responseType.addAssertion(new ResponseType.RTChoiceType(assertionType));
        return responseType;
    }

    public static ResponseType createResponseType(String ID, IssuerInfoHolder issuerInfo, Element encryptedAssertion) throws ConfigurationException {
        ResponseType responseType = new ResponseType(ID, XMLTimeUtil.getIssueInstant());
        NameIDType issuer = issuerInfo.getIssuer();
        responseType.setIssuer(issuer);
        String statusCode = issuerInfo.getStatusCode();
        if (statusCode == null) {
            throw logger.issuerInfoMissingStatusCodeError();
        }
        responseType.setStatus(JBossSAMLAuthnResponseFactory.createStatusType(statusCode));
        responseType.addAssertion(new ResponseType.RTChoiceType(new EncryptedAssertionType(encryptedAssertion)));
        return responseType;
    }
}

