/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.util.function.Function;
import org.jboss.as.ejb3.component.stateful.EJBClientContextIdentifierObjectTable;
import org.jboss.as.ejb3.component.stateful.EJBClientContextIdentifierResolver;
import org.jboss.as.ejb3.component.stateful.MarshallingConfigurationContext;
import org.jboss.as.ejb3.component.stateful.StatefulSessionBeanClassTable;
import org.jboss.as.ejb3.component.stateful.StatefulSessionBeanSerializabilityChecker;
import org.jboss.as.ejb3.deployment.ModuleDeployment;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.marshalling.ObjectResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.SerializabilityChecker;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.marshalling.jboss.ExternalizerObjectTable;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingConfigurationRepository;

public class MarshallingConfigurationRepositoryValue
implements Value<MarshallingConfigurationRepository>,
MarshallingConfigurationContext {
    private final Value<ModuleDeployment> deployment;
    private final Value<Module> module;

    public static ServiceName getServiceName(ServiceName deploymentUnitServiceName) {
        return deploymentUnitServiceName.append(new String[]{"marshalling"});
    }

    public MarshallingConfigurationRepositoryValue(Value<ModuleDeployment> deployment, Value<Module> module) {
        this.deployment = deployment;
        this.module = module;
    }

    public MarshallingConfigurationRepository getValue() {
        return new SimpleMarshallingConfigurationRepository(MarshallingVersion.class, (Enum)MarshallingVersion.CURRENT, (Object)this);
    }

    @Override
    public Module getModule() {
        return (Module)this.module.getValue();
    }

    @Override
    public ModuleDeployment getDeployment() {
        return (ModuleDeployment)this.deployment.getValue();
    }

    static enum MarshallingVersion implements Function<MarshallingConfigurationContext, MarshallingConfiguration>
    {
        VERSION_1{

            @Override
            public MarshallingConfiguration apply(MarshallingConfigurationContext context) {
                Module module = context.getModule();
                ModuleDeployment deployment = context.getDeployment();
                MarshallingConfiguration config = new MarshallingConfiguration();
                config.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)module.getModuleLoader()));
                config.setSerializabilityChecker((SerializabilityChecker)new StatefulSessionBeanSerializabilityChecker(deployment));
                config.setClassTable((ClassTable)new StatefulSessionBeanClassTable());
                config.setObjectTable((ObjectTable)new EJBClientContextIdentifierObjectTable());
                return config;
            }
        }
        ,
        VERSION_2{

            @Override
            public MarshallingConfiguration apply(MarshallingConfigurationContext context) {
                Module module = context.getModule();
                ModuleDeployment deployment = context.getDeployment();
                MarshallingConfiguration config = new MarshallingConfiguration();
                config.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)module.getModuleLoader()));
                config.setSerializabilityChecker((SerializabilityChecker)new StatefulSessionBeanSerializabilityChecker(deployment));
                config.setClassTable((ClassTable)new StatefulSessionBeanClassTable());
                config.setObjectResolver((ObjectResolver)new EJBClientContextIdentifierResolver());
                config.setObjectTable((ObjectTable)new ExternalizerObjectTable((ClassLoader)module.getClassLoader()));
                return config;
            }
        };

        static final MarshallingVersion CURRENT;

        static {
            CURRENT = VERSION_2;
        }
    }
}

