/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.proton;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.jms.client.ActiveMQConnection;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPIllegalStateException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInternalErrorException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPNotFoundException;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolMessageBundle;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpJmsSelectorFilter;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpNoLocalFilter;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonDeliveryHandler;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonInitializable;
import org.apache.activemq.artemis.protocol.amqp.util.CreditsSemaphore;
import org.apache.activemq.artemis.protocol.amqp.util.NettyWritable;
import org.apache.activemq.artemis.selector.filter.FilterException;
import org.apache.activemq.artemis.selector.impl.SelectorParser;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.messaging.Outcome;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.messaging.Released;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.TerminusDurability;
import org.apache.qpid.proton.amqp.messaging.TerminusExpiryPolicy;
import org.apache.qpid.proton.amqp.transaction.TransactionalState;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Sender;
import org.jboss.logging.Logger;

public class ProtonServerSenderContext
extends ProtonInitializable
implements ProtonDeliveryHandler {
    private static final Logger log = Logger.getLogger(ProtonServerSenderContext.class);
    private static final Symbol COPY = Symbol.valueOf((String)"copy");
    private static final Symbol TOPIC = Symbol.valueOf((String)"topic");
    private Object brokerConsumer;
    protected final AMQPSessionContext protonSession;
    protected final Sender sender;
    protected final AMQPConnectionContext connection;
    protected boolean closed = false;
    protected final AMQPSessionCallback sessionSPI;
    protected CreditsSemaphore creditsSemaphore = new CreditsSemaphore(0);

    public ProtonServerSenderContext(AMQPConnectionContext connection, Sender sender, AMQPSessionContext protonSession, AMQPSessionCallback server) {
        this.connection = connection;
        this.sender = sender;
        this.protonSession = protonSession;
        this.sessionSPI = server;
    }

    public Object getBrokerConsumer() {
        return this.brokerConsumer;
    }

    @Override
    public void onFlow(int currentCredits, boolean drain) {
        this.creditsSemaphore.setCredits(currentCredits);
        this.sessionSPI.onFlowConsumer(this.brokerConsumer, currentCredits, drain);
    }

    public Sender getSender() {
        return this.sender;
    }

    public void start() throws ActiveMQAMQPException {
        this.sessionSPI.start();
        try {
            if (this.brokerConsumer != null) {
                this.sessionSPI.startSender(this.brokerConsumer);
            }
        }
        catch (Exception e) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorStartingConsumer(e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void initialise() throws Exception {
        QueueQueryResult result;
        String queue;
        String pubId;
        String clientId;
        Map.Entry<Symbol, DescribedType> filter;
        boolean isPubSub;
        Map.Entry<Symbol, DescribedType> filter2;
        super.initialise();
        Source source = (Source)this.sender.getRemoteSource();
        String selector = null;
        HashMap<Symbol, DescribedType> supportedFilters = new HashMap<Symbol, DescribedType>();
        if (source != null && (filter2 = AmqpSupport.findFilter(source.getFilter(), AmqpSupport.JMS_SELECTOR_FILTER_IDS)) != null) {
            selector = filter2.getValue().getDescribed().toString();
            try {
                SelectorParser.parse((String)selector);
            }
            catch (FilterException e) {
                throw new ActiveMQAMQPException(AmqpError.INVALID_FIELD, "Invalid filter", ActiveMQExceptionType.INVALID_FILTER_EXPRESSION);
            }
            supportedFilters.put(filter2.getKey(), filter2.getValue());
        }
        boolean bl = isPubSub = ProtonServerSenderContext.hasCapabilities(TOPIC, source) || this.isPubSub(source);
        if (isPubSub && (filter = AmqpSupport.findFilter(source.getFilter(), AmqpSupport.NO_LOCAL_FILTER_IDS)) != null) {
            String remoteContainerId = this.sender.getSession().getConnection().getRemoteContainer();
            String noLocalFilter = ActiveMQConnection.CONNECTION_ID_PROPERTY_NAME.toString() + "<>'" + remoteContainerId + "'";
            selector = selector != null ? selector + " AND " + noLocalFilter : noLocalFilter;
            supportedFilters.put(filter.getKey(), filter.getValue());
        }
        if (source == null) {
            clientId = this.getClientId();
            queue = ProtonServerSenderContext.createQueueName(clientId, pubId = this.sender.getName());
            result = this.sessionSPI.queueQuery(queue, false);
            if (!result.isExists()) throw new ActiveMQAMQPNotFoundException("Unknown subscription link: " + this.sender.getName());
            source = new Source();
            source.setAddress(queue);
            source.setDurable(TerminusDurability.UNSETTLED_STATE);
            source.setExpiryPolicy(TerminusExpiryPolicy.NEVER);
            source.setDistributionMode(COPY);
            source.setCapabilities(new Symbol[]{TOPIC});
            SimpleString filterString = result.getFilterString();
            if (filterString != null) {
                selector = filterString.toString();
                boolean noLocal = false;
                String remoteContainerId = this.sender.getSession().getConnection().getRemoteContainer();
                String noLocalFilter = ActiveMQConnection.CONNECTION_ID_PROPERTY_NAME.toString() + "<>'" + remoteContainerId + "'";
                if (selector.endsWith(noLocalFilter)) {
                    if (selector.length() > noLocalFilter.length()) {
                        noLocalFilter = " AND " + noLocalFilter;
                        selector = selector.substring(0, selector.length() - noLocalFilter.length());
                    } else {
                        selector = null;
                    }
                    noLocal = true;
                }
                if (noLocal) {
                    supportedFilters.put(AmqpSupport.NO_LOCAL_NAME, AmqpNoLocalFilter.NO_LOCAL);
                }
                if (selector != null && !selector.trim().isEmpty()) {
                    supportedFilters.put(AmqpSupport.JMS_SELECTOR_NAME, new AmqpJmsSelectorFilter(selector));
                }
            }
            this.sender.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
        } else if (source.getDynamic()) {
            queue = UUID.randomUUID().toString();
            try {
                this.sessionSPI.createTemporaryQueue(queue);
            }
            catch (Exception e) {
                throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorCreatingTemporaryQueue(e.getMessage());
            }
            source.setAddress(queue);
        } else {
            if (isPubSub) {
                if (TerminusDurability.UNSETTLED_STATE.equals((Object)source.getDurable()) || TerminusDurability.CONFIGURATION.equals((Object)source.getDurable())) {
                    clientId = this.getClientId();
                    queue = ProtonServerSenderContext.createQueueName(clientId, pubId = this.sender.getName());
                    result = this.sessionSPI.queueQuery(queue, false);
                    if (result.isExists()) {
                        if (!Objects.equals(result.getFilterString(), SimpleString.toSimpleString((String)selector)) || this.sender.getSource() != null && !this.sender.getSource().getAddress().equals(result.getAddress().toString())) {
                            if (result.getConsumerCount() != 0) throw new ActiveMQAMQPIllegalStateException("Unable to recreate subscription, consumers already exist");
                            this.sessionSPI.deleteQueue(queue);
                            this.sessionSPI.createDurableQueue(source.getAddress(), queue, selector);
                        }
                    } else {
                        this.sessionSPI.createDurableQueue(source.getAddress(), queue, selector);
                    }
                } else {
                    queue = UUID.randomUUID().toString();
                    try {
                        this.sessionSPI.createTemporaryQueue(source.getAddress(), queue, selector);
                    }
                    catch (Exception e) {
                        throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorCreatingTemporaryQueue(e.getMessage());
                    }
                }
            } else {
                queue = source.getAddress();
            }
            if (queue == null) {
                throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.sourceAddressNotSet();
            }
            try {
                if (!this.sessionSPI.queueQuery(queue, !isPubSub).isExists()) {
                    throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.sourceAddressDoesntExist();
                }
            }
            catch (ActiveMQAMQPNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ActiveMQAMQPInternalErrorException(e.getMessage(), e);
            }
        }
        source.setFilter(supportedFilters.isEmpty() ? null : supportedFilters);
        boolean browseOnly = !isPubSub && source.getDistributionMode() != null && source.getDistributionMode().equals(COPY);
        try {
            this.brokerConsumer = this.sessionSPI.createSender(this, queue, isPubSub ? null : selector, browseOnly);
            return;
        }
        catch (Exception e) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorCreatingConsumer(e.getMessage());
        }
    }

    protected String getClientId() {
        return this.connection.getRemoteContainer();
    }

    private boolean isPubSub(Source source) {
        String pubSubPrefix = this.sessionSPI.getPubSubPrefix();
        return source != null && pubSubPrefix != null && source.getAddress() != null && source.getAddress().startsWith(pubSubPrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(ErrorCondition condition) throws ActiveMQAMQPException {
        this.closed = true;
        if (condition != null) {
            this.sender.setCondition(condition);
        }
        this.protonSession.removeSender(this.sender);
        Object object = this.connection.getLock();
        synchronized (object) {
            this.sender.close();
        }
        this.connection.flush();
        try {
            this.sessionSPI.closeSender(this.brokerConsumer);
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
            throw new ActiveMQAMQPInternalErrorException(e.getMessage());
        }
    }

    @Override
    public void close(boolean remoteLinkClose) throws ActiveMQAMQPException {
        try {
            Source source;
            this.sessionSPI.closeSender(this.brokerConsumer);
            if (remoteLinkClose && (source = (Source)this.sender.getSource()) != null && source.getAddress() != null && (ProtonServerSenderContext.hasCapabilities(TOPIC, source) || this.isPubSub(source))) {
                String queueName = source.getAddress();
                QueueQueryResult result = this.sessionSPI.queueQuery(queueName, false);
                if (result.isExists() && source.getDynamic()) {
                    this.sessionSPI.deleteQueue(queueName);
                } else {
                    String pubId;
                    String clientId = this.getClientId();
                    String queue = ProtonServerSenderContext.createQueueName(clientId, pubId = this.sender.getName());
                    result = this.sessionSPI.queueQuery(queue, false);
                    if (result.isExists()) {
                        if (result.getConsumerCount() > 0) {
                            System.out.println("error");
                        }
                        this.sessionSPI.deleteQueue(queue);
                    }
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
            throw new ActiveMQAMQPInternalErrorException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(Delivery delivery) throws ActiveMQAMQPException {
        Object message = delivery.getContext();
        boolean preSettle = this.sender.getRemoteSenderSettleMode() == SenderSettleMode.SETTLED;
        DeliveryState remoteState = delivery.getRemoteState();
        if (remoteState != null) {
            if (remoteState instanceof TransactionalState) {
                Outcome outcome;
                TransactionalState txState = (TransactionalState)remoteState;
                Transaction tx = this.sessionSPI.getTransaction(txState.getTxnId());
                if (txState.getOutcome() != null && (outcome = txState.getOutcome()) instanceof Accepted) {
                    if (!delivery.remotelySettled()) {
                        TransactionalState txAccepted = new TransactionalState();
                        txAccepted.setOutcome((Outcome)Accepted.getInstance());
                        txAccepted.setTxnId(txState.getTxnId());
                        delivery.disposition((DeliveryState)txAccepted);
                    }
                    try {
                        this.sessionSPI.ack(tx, this.brokerConsumer, message);
                    }
                    catch (Exception e) {
                        throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorAcknowledgingMessage(message.toString(), e.getMessage());
                    }
                }
            } else {
                if (remoteState instanceof Accepted) {
                    try {
                        this.sessionSPI.ack(null, this.brokerConsumer, message);
                    }
                    catch (Exception e) {
                        throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorAcknowledgingMessage(message.toString(), e.getMessage());
                    }
                }
                if (remoteState instanceof Released) {
                    try {
                        this.sessionSPI.cancel(this.brokerConsumer, message, false);
                    }
                    catch (Exception e) {
                        throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorCancellingMessage(message.toString(), e.getMessage());
                    }
                }
                if (remoteState instanceof Rejected || remoteState instanceof Modified) {
                    try {
                        this.sessionSPI.cancel(this.brokerConsumer, message, true);
                    }
                    catch (Exception e) {
                        throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.errorCancellingMessage(message.toString(), e.getMessage());
                    }
                }
            }
            if (!preSettle) {
                this.protonSession.replaceTag(delivery.getTag());
            }
            Object object = this.connection.getLock();
            synchronized (object) {
                delivery.settle();
                this.sender.offer(1);
            }
        }
    }

    public synchronized void checkState() {
        this.sessionSPI.resumeDelivery(this.brokerConsumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deliverMessage(Object message, int deliveryCount) throws Exception {
        if (this.closed) {
            System.err.println("Message can't be delivered as it's closed");
            return 0;
        }
        if (!this.creditsSemaphore.tryAcquire()) {
            try {
                this.creditsSemaphore.acquire();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        boolean preSettle = this.sender.getRemoteSenderSettleMode() == SenderSettleMode.SETTLED;
        byte[] tag = preSettle ? new byte[]{} : this.protonSession.getTag();
        ByteBuf nettyBuffer = PooledByteBufAllocator.DEFAULT.heapBuffer(1024);
        try {
            long messageFormat = 0L;
            try {
                messageFormat = this.sessionSPI.encodeMessage(message, deliveryCount, new NettyWritable(nettyBuffer));
            }
            catch (Throwable e) {
                log.warn((Object)e.getMessage(), e);
                throw new ActiveMQAMQPInternalErrorException(e.getMessage(), e);
            }
            int size = nettyBuffer.writerIndex();
            Object object = this.connection.getLock();
            synchronized (object) {
                Delivery delivery = this.sender.delivery(tag, 0, tag.length);
                delivery.setMessageFormat((int)messageFormat);
                delivery.setContext(message);
                this.sender.send(nettyBuffer.array(), nettyBuffer.arrayOffset() + nettyBuffer.readerIndex(), nettyBuffer.readableBytes());
                if (preSettle) {
                    this.sessionSPI.ack(null, this.brokerConsumer, message);
                    delivery.settle();
                } else {
                    this.sender.advance();
                }
            }
            this.connection.flush();
            int n = size;
            return n;
        }
        finally {
            nettyBuffer.release();
        }
    }

    private static boolean hasCapabilities(Symbol symbol, Source source) {
        if (source != null && source.getCapabilities() != null) {
            for (Symbol cap : source.getCapabilities()) {
                if (!symbol.equals(cap)) continue;
                return true;
            }
        }
        return false;
    }

    private static String createQueueName(String clientId, String pubId) {
        return clientId + "." + pubId;
    }
}

