/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.time;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.policy.evaluation.Evaluation;
import org.keycloak.authorization.policy.provider.PolicyProvider;

public class TimePolicyProvider
implements PolicyProvider {
    static String DEFAULT_DATE_PATTERN = "yyyy-MM-dd hh:mm:ss";

    public void evaluate(Evaluation evaluation) {
        Policy policy = evaluation.getPolicy();
        SimpleDateFormat dateFormat = new SimpleDateFormat(DEFAULT_DATE_PATTERN);
        Date actualDate = new Date();
        try {
            String notBefore = (String)policy.getConfig().get("nbf");
            if (notBefore != null && !"".equals(notBefore) && actualDate.before(dateFormat.parse(TimePolicyProvider.format(notBefore)))) {
                evaluation.deny();
                return;
            }
            String notOnOrAfter = (String)policy.getConfig().get("noa");
            if (notOnOrAfter != null && !"".equals(notOnOrAfter) && actualDate.after(dateFormat.parse(TimePolicyProvider.format(notOnOrAfter)))) {
                evaluation.deny();
                return;
            }
            if (this.isInvalid(actualDate, 5, "dayMonth", policy) || this.isInvalid(actualDate, 2, "month", policy) || this.isInvalid(actualDate, 1, "year", policy) || this.isInvalid(actualDate, 11, "hour", policy) || this.isInvalid(actualDate, 12, "minute", policy)) {
                evaluation.deny();
                return;
            }
            evaluation.grant();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not evaluate time-based policy [" + policy.getName() + "].", e);
        }
    }

    private boolean isInvalid(Date actualDate, int timeConstant, String configName, Policy policy) {
        String end;
        String start;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(actualDate);
        int dateField = calendar.get(timeConstant);
        if (2 == timeConstant) {
            ++dateField;
        }
        return (start = (String)policy.getConfig().get(configName)) != null && ((end = (String)policy.getConfig().get(configName + "End")) != null ? dateField < Integer.parseInt(start) || dateField > Integer.parseInt(end) : dateField != Integer.parseInt(start));
    }

    static String format(String notBefore) {
        String trimmed = notBefore.trim();
        if (trimmed.length() == 10) {
            notBefore = trimmed + " 00:00:00";
        }
        return notBefore;
    }

    public void close() {
    }
}

