/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.util.HashSet;
import java.util.Set;
import org.keycloak.common.util.Time;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.services.managers.CodeGenerateUtil;
import org.keycloak.sessions.CommonClientSessionModel;

public class ClientSessionCode<CLIENT_SESSION extends CommonClientSessionModel> {
    private KeycloakSession session;
    private final RealmModel realm;
    private final CLIENT_SESSION commonLoginSession;

    public ClientSessionCode(KeycloakSession session, RealmModel realm, CLIENT_SESSION commonLoginSession) {
        this.session = session;
        this.realm = realm;
        this.commonLoginSession = commonLoginSession;
    }

    public static <CLIENT_SESSION extends CommonClientSessionModel> ParseResult<CLIENT_SESSION> parseResult(String code, KeycloakSession session, RealmModel realm, ClientModel client, EventBuilder event, Class<CLIENT_SESSION> sessionClass) {
        ParseResult result = new ParseResult();
        if (code == null) {
            result.illegalHash = true;
            return result;
        }
        try {
            CodeGenerateUtil.ClientSessionParser<CLIENT_SESSION> clientSessionParser = CodeGenerateUtil.getParser(sessionClass);
            result.clientSession = ClientSessionCode.getClientSession(code, session, realm, client, event, clientSessionParser);
            if (result.clientSession == null) {
                result.authSessionNotFound = true;
                return result;
            }
            if (!clientSessionParser.verifyCode(session, code, result.clientSession)) {
                result.illegalHash = true;
                return result;
            }
            if (clientSessionParser.isExpired(session, code, result.clientSession)) {
                result.expiredToken = true;
                return result;
            }
            result.code = new ClientSessionCode(session, realm, result.clientSession);
            return result;
        }
        catch (RuntimeException e) {
            result.illegalHash = true;
            return result;
        }
    }

    public static <CLIENT_SESSION extends CommonClientSessionModel> CLIENT_SESSION getClientSession(String code, KeycloakSession session, RealmModel realm, ClientModel client, EventBuilder event, Class<CLIENT_SESSION> sessionClass) {
        CodeGenerateUtil.ClientSessionParser<CLIENT_SESSION> clientSessionParser = CodeGenerateUtil.getParser(sessionClass);
        return ClientSessionCode.getClientSession(code, session, realm, client, event, clientSessionParser);
    }

    private static <CLIENT_SESSION extends CommonClientSessionModel> CLIENT_SESSION getClientSession(String code, KeycloakSession session, RealmModel realm, ClientModel client, EventBuilder event, CodeGenerateUtil.ClientSessionParser<CLIENT_SESSION> clientSessionParser) {
        return clientSessionParser.parseSession(code, session, realm, client, event);
    }

    public CLIENT_SESSION getClientSession() {
        return this.commonLoginSession;
    }

    public boolean isValid(String requestedAction, ActionType actionType) {
        if (!this.isValidAction(requestedAction)) {
            return false;
        }
        return this.isActionActive(actionType);
    }

    public boolean isActionActive(ActionType actionType) {
        int lifespan;
        CodeGenerateUtil.ClientSessionParser<?> clientSessionParser = CodeGenerateUtil.getParser(this.commonLoginSession.getClass());
        int timestamp = clientSessionParser.getTimestamp(this.commonLoginSession);
        switch (actionType) {
            case CLIENT: {
                lifespan = this.realm.getAccessCodeLifespan();
                break;
            }
            case LOGIN: {
                lifespan = this.realm.getAccessCodeLifespanLogin() > 0 ? this.realm.getAccessCodeLifespanLogin() : this.realm.getAccessCodeLifespanUserAction();
                break;
            }
            case USER: {
                lifespan = this.realm.getAccessCodeLifespanUserAction();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return timestamp + lifespan > Time.currentTime();
    }

    public boolean isValidAction(String requestedAction) {
        String action = this.commonLoginSession.getAction();
        if (action == null) {
            return false;
        }
        return action.equals(requestedAction);
    }

    public void removeExpiredClientSession() {
        CodeGenerateUtil.ClientSessionParser<?> parser = CodeGenerateUtil.getParser(this.commonLoginSession.getClass());
        parser.removeExpiredSession(this.session, this.commonLoginSession);
    }

    public Set<RoleModel> getRequestedRoles() {
        return ClientSessionCode.getRequestedRoles(this.commonLoginSession, this.realm);
    }

    public static Set<RoleModel> getRequestedRoles(CommonClientSessionModel clientSession, RealmModel realm) {
        HashSet<RoleModel> requestedRoles = new HashSet<RoleModel>();
        for (String roleId : clientSession.getRoles()) {
            RoleModel role = realm.getRoleById(roleId);
            if (role == null) continue;
            requestedRoles.add(role);
        }
        return requestedRoles;
    }

    public Set<ProtocolMapperModel> getRequestedProtocolMappers() {
        return ClientSessionCode.getRequestedProtocolMappers(this.commonLoginSession.getProtocolMappers(), this.commonLoginSession.getClient());
    }

    public static Set<ProtocolMapperModel> getRequestedProtocolMappers(Set<String> protocolMappers, ClientModel client) {
        HashSet<ProtocolMapperModel> requestedProtocolMappers = new HashSet<ProtocolMapperModel>();
        ClientTemplateModel template = client.getClientTemplate();
        if (protocolMappers != null) {
            for (String protocolMapperId : protocolMappers) {
                ProtocolMapperModel protocolMapper = client.getProtocolMapperById(protocolMapperId);
                if (protocolMapper == null && template != null) {
                    protocolMapper = template.getProtocolMapperById(protocolMapperId);
                }
                if (protocolMapper == null) continue;
                requestedProtocolMappers.add(protocolMapper);
            }
        }
        return requestedProtocolMappers;
    }

    public void setAction(String action) {
        this.commonLoginSession.setAction(action);
        CodeGenerateUtil.ClientSessionParser<?> clientSessionParser = CodeGenerateUtil.getParser(this.commonLoginSession.getClass());
        clientSessionParser.setTimestamp(this.commonLoginSession, Time.currentTime());
    }

    public String getOrGenerateCode() {
        CodeGenerateUtil.ClientSessionParser<?> parser = CodeGenerateUtil.getParser(this.commonLoginSession.getClass());
        return parser.retrieveCode(this.session, this.commonLoginSession);
    }

    public static class ParseResult<CLIENT_SESSION extends CommonClientSessionModel> {
        ClientSessionCode<CLIENT_SESSION> code;
        boolean authSessionNotFound;
        boolean illegalHash;
        boolean expiredToken;
        CLIENT_SESSION clientSession;

        public ClientSessionCode<CLIENT_SESSION> getCode() {
            return this.code;
        }

        public boolean isAuthSessionNotFound() {
            return this.authSessionNotFound;
        }

        public boolean isIllegalHash() {
            return this.illegalHash;
        }

        public boolean isExpiredToken() {
            return this.expiredToken;
        }

        public CLIENT_SESSION getClientSession() {
            return this.clientSession;
        }
    }

    public static enum ActionType {
        CLIENT,
        LOGIN,
        USER;

    }
}

