/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.ConnectionKey;
import org.jboss.remoting3.EndpointImpl;
import org.jboss.remoting3.ManagedConnection;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.xnio.Cancellable;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

final class ConnectionInfo {
    final OptionMap connectOptions;
    State state = new None();
    private static final IoFuture<Connection> RETRY = new EmptyIoFuture();

    ConnectionInfo(OptionMap connectOptions) {
        this.connectOptions = connectOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IoFuture<Connection> getConnection(EndpointImpl endpoint, ConnectionKey key, AuthenticationConfiguration authenticationConfiguration, boolean doConnect) {
        State state;
        IoFuture<Connection> result;
        do {
            ConnectionInfo connectionInfo = this;
            synchronized (connectionInfo) {
                state = this.state;
            }
        } while ((result = state.getConnection(endpoint, key, authenticationConfiguration, doConnect)) == RETRY);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectionClosed(AuthenticationConfiguration authenticationConfiguration, FutureResult<Connection> futureResult) {
        State state;
        do {
            ConnectionInfo connectionInfo = this;
            synchronized (connectionInfo) {
                state = this.state;
            }
        } while (!state.connectionClosed(authenticationConfiguration, futureResult));
    }

    void splice(FutureResult<Connection> futureResult, IoFuture<Connection> realFuture, final AuthenticationConfiguration authConfig) {
        futureResult.addCancelHandler(realFuture);
        realFuture.addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<Connection, FutureResult<Connection>>(){

            public void handleCancelled(FutureResult<Connection> futureResult1) {
                futureResult1.setCancelled();
            }

            public void handleFailed(IOException exception, FutureResult<Connection> futureResult1) {
                futureResult1.setException(exception);
            }

            public void handleDone(Connection connection, FutureResult<Connection> futureResult1) {
                futureResult1.setResult((Object)new ManagedConnection(connection, ConnectionInfo.this, authConfig, futureResult1));
            }
        }, futureResult);
    }

    static class EmptyIoFuture
    implements IoFuture<Connection> {
        EmptyIoFuture() {
        }

        public IoFuture<Connection> cancel() {
            throw Assert.unsupported();
        }

        public IoFuture.Status getStatus() {
            throw Assert.unsupported();
        }

        public IoFuture.Status await() {
            throw Assert.unsupported();
        }

        public IoFuture.Status await(long time, TimeUnit timeUnit) {
            throw Assert.unsupported();
        }

        public IoFuture.Status awaitInterruptibly() throws InterruptedException {
            throw Assert.unsupported();
        }

        public IoFuture.Status awaitInterruptibly(long time, TimeUnit timeUnit) throws InterruptedException {
            throw Assert.unsupported();
        }

        public Connection get() throws IOException, CancellationException {
            throw Assert.unsupported();
        }

        public Connection getInterruptibly() throws IOException, InterruptedException, CancellationException {
            throw Assert.unsupported();
        }

        public IOException getException() throws IllegalStateException {
            throw Assert.unsupported();
        }

        public <A> IoFuture<Connection> addNotifier(IoFuture.Notifier<? super Connection, A> notifier, A attachment) {
            throw Assert.unsupported();
        }
    }

    final class NotShared
    extends State {
        private final Map<AuthenticationConfiguration, FutureResult<Connection>> connections;

        NotShared(Map<AuthenticationConfiguration, FutureResult<Connection>> connections) {
            this.connections = connections;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        IoFuture<Connection> getConnection(EndpointImpl endpoint, ConnectionKey key, AuthenticationConfiguration authenticationConfiguration, boolean doConnect) {
            FutureResult<Connection> future = this.connections.get(authenticationConfiguration);
            if (future != null) {
                return future.getIoFuture();
            }
            if (!doConnect) {
                return null;
            }
            ConnectionInfo connectionInfo = ConnectionInfo.this;
            synchronized (connectionInfo) {
                State oldState = ConnectionInfo.this.state;
                if (oldState == this) {
                    IoFuture<Connection> attempt = endpoint.connect(key.getRealUri(), null, ConnectionInfo.this.connectOptions, key.getSslContext(), authenticationConfiguration);
                    HashMap<AuthenticationConfiguration, FutureResult<Connection>> newConnections = new HashMap<AuthenticationConfiguration, FutureResult<Connection>>(this.connections);
                    FutureResult futureResult = new FutureResult();
                    ConnectionInfo.this.splice((FutureResult<Connection>)futureResult, attempt, authenticationConfiguration);
                    newConnections.put(authenticationConfiguration, (FutureResult<Connection>)futureResult);
                    return attempt;
                }
            }
            return RETRY;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean connectionClosed(AuthenticationConfiguration authenticationConfiguration, FutureResult<Connection> futureResult) {
            State newState;
            FutureResult<Connection> mapVal = this.connections.get(authenticationConfiguration);
            if (!futureResult.equals(mapVal)) {
                return true;
            }
            if (this.connections.size() == 1) {
                newState = new None();
            } else {
                HashMap<AuthenticationConfiguration, FutureResult<Connection>> newMap = new HashMap<AuthenticationConfiguration, FutureResult<Connection>>(this.connections);
                newMap.remove(authenticationConfiguration);
                newState = new NotShared(newMap);
            }
            ConnectionInfo connectionInfo = ConnectionInfo.this;
            synchronized (connectionInfo) {
                if (ConnectionInfo.this.state == this) {
                    ConnectionInfo.this.state = newState;
                    return true;
                }
            }
            return false;
        }
    }

    final class Shared
    extends State {
        private final FutureResult<Connection> sharedConnection;
        private final Map<AuthenticationConfiguration, FutureResult<Connection>> leftovers;

        Shared(FutureResult<Connection> sharedConnection, Map<AuthenticationConfiguration, FutureResult<Connection>> leftovers) {
            this.sharedConnection = sharedConnection;
            this.leftovers = leftovers;
        }

        @Override
        IoFuture<Connection> getConnection(EndpointImpl endpoint, ConnectionKey key, AuthenticationConfiguration authenticationConfiguration, boolean doConnect) {
            return this.leftovers.getOrDefault(authenticationConfiguration, this.sharedConnection).getIoFuture();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean connectionClosed(AuthenticationConfiguration authenticationConfiguration, FutureResult<Connection> futureResult) {
            State newState;
            if (futureResult == this.sharedConnection) {
                newState = this.leftovers.isEmpty() ? new None() : new NotShared(this.leftovers);
            } else {
                Map<AuthenticationConfiguration, FutureResult<Connection>> newMap;
                FutureResult<Connection> mapVal = this.leftovers.get(authenticationConfiguration);
                if (!futureResult.equals(mapVal)) {
                    return true;
                }
                if (this.leftovers.size() == 1) {
                    newMap = Collections.emptyMap();
                } else {
                    newMap = new HashMap<AuthenticationConfiguration, FutureResult<Connection>>(this.leftovers);
                    newMap.remove(authenticationConfiguration);
                }
                newState = new Shared(this.sharedConnection, newMap);
            }
            ConnectionInfo connectionInfo = ConnectionInfo.this;
            synchronized (connectionInfo) {
                if (ConnectionInfo.this.state == this) {
                    ConnectionInfo.this.state = newState;
                    return true;
                }
            }
            return false;
        }
    }

    final class MaybeShared
    extends State {
        private final AuthenticationConfiguration authenticationConfiguration;
        private final IoFuture<Connection> attempt;
        private final Map<AuthenticationConfiguration, FutureResult<Connection>> pendingAttempts = new HashMap<AuthenticationConfiguration, FutureResult<Connection>>();

        MaybeShared(AuthenticationConfiguration authenticationConfiguration, IoFuture<Connection> attempt) {
            this.authenticationConfiguration = authenticationConfiguration;
            this.attempt = attempt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        IoFuture<Connection> getConnection(EndpointImpl endpoint, ConnectionKey key, AuthenticationConfiguration authenticationConfiguration, boolean doConnect) {
            Map<AuthenticationConfiguration, FutureResult<Connection>> map = this.pendingAttempts;
            synchronized (map) {
                if (authenticationConfiguration.equals(this.authenticationConfiguration)) {
                    return this.attempt;
                }
                FutureResult futureResult = this.pendingAttempts.get(authenticationConfiguration);
                if (futureResult != null) {
                    return futureResult.getIoFuture();
                }
                if (!doConnect) {
                    return null;
                }
                futureResult = new FutureResult(endpoint.getExecutor());
                this.pendingAttempts.put(authenticationConfiguration, (FutureResult<Connection>)futureResult);
                assert (doConnect);
                IoFuture ioFuture = futureResult.getIoFuture();
                final FutureResult finalFutureResult = futureResult;
                futureResult.addCancelHandler(new Cancellable(){

                    public Cancellable cancel() {
                        finalFutureResult.setCancelled();
                        return this;
                    }
                });
                return ioFuture;
            }
        }

        @Override
        boolean connectionClosed(AuthenticationConfiguration authenticationConfiguration, FutureResult<Connection> futureResult) {
            this.attempt.await();
            return false;
        }
    }

    final class None
    extends State {
        None() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        IoFuture<Connection> getConnection(final EndpointImpl endpoint, final ConnectionKey key, final AuthenticationConfiguration authenticationConfiguration, boolean doConnect) {
            if (!doConnect) {
                return null;
            }
            ConnectionInfo connectionInfo = ConnectionInfo.this;
            synchronized (connectionInfo) {
                State oldState = ConnectionInfo.this.state;
                if (oldState == this) {
                    IoFuture<Connection> attempt = endpoint.connect(key.getRealUri(), null, ConnectionInfo.this.connectOptions, key.getSslContext(), authenticationConfiguration);
                    final MaybeShared maybeShared = new MaybeShared(authenticationConfiguration, attempt);
                    final FutureResult futureResult = new FutureResult();
                    ConnectionInfo.this.splice((FutureResult<Connection>)futureResult, attempt, authenticationConfiguration);
                    attempt.addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<Connection, Void>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void handleCancelled(Void attachment) {
                            Map map = maybeShared.pendingAttempts;
                            synchronized (map) {
                                for (Map.Entry pendingAttempt : maybeShared.pendingAttempts.entrySet()) {
                                    ((FutureResult)pendingAttempt.getValue()).setCancelled();
                                }
                            }
                            this.clear();
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void handleFailed(IOException exception, Void attachment) {
                            Map map = maybeShared.pendingAttempts;
                            synchronized (map) {
                                for (Map.Entry pendingAttempt : maybeShared.pendingAttempts.entrySet()) {
                                    ((FutureResult)pendingAttempt.getValue()).setException(exception);
                                }
                            }
                            this.clear();
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void handleDone(Connection connection, Void attachment) {
                            ConnectionInfo outer;
                            ConnectionInfo connectionInfo = outer = ConnectionInfo.this;
                            synchronized (connectionInfo) {
                                assert (ConnectionInfo.this.state == maybeShared);
                                ConnectionInfo.this.state = connection.supportsRemoteAuth() ? new Shared((FutureResult<Connection>)futureResult, Collections.emptyMap()) : new NotShared(Collections.singletonMap(authenticationConfiguration, futureResult));
                                Map map = maybeShared.pendingAttempts;
                                synchronized (map) {
                                    for (Map.Entry pendingAttempt : maybeShared.pendingAttempts.entrySet()) {
                                        AuthenticationConfiguration pendingAuthenticationConfiguration = (AuthenticationConfiguration)pendingAttempt.getKey();
                                        FutureResult pendingFutureResult = (FutureResult)pendingAttempt.getValue();
                                        IoFuture<Connection> realAttempt = outer.getConnection(endpoint, key, pendingAuthenticationConfiguration, true);
                                        ConnectionInfo.this.splice((FutureResult<Connection>)pendingFutureResult, realAttempt, pendingAuthenticationConfiguration);
                                    }
                                }
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        private void clear() {
                            ConnectionInfo outer;
                            ConnectionInfo connectionInfo = outer = ConnectionInfo.this;
                            synchronized (connectionInfo) {
                                assert (ConnectionInfo.this.state == maybeShared);
                                ConnectionInfo.this.state = None.this;
                            }
                        }
                    }, null);
                    ConnectionInfo.this.state = maybeShared;
                    return futureResult.getIoFuture();
                }
            }
            return RETRY;
        }

        @Override
        boolean connectionClosed(AuthenticationConfiguration authenticationConfiguration, FutureResult<Connection> futureResult) {
            return true;
        }
    }

    static abstract class State {
        State() {
        }

        abstract IoFuture<Connection> getConnection(EndpointImpl var1, ConnectionKey var2, AuthenticationConfiguration var3, boolean var4);

        abstract boolean connectionClosed(AuthenticationConfiguration var1, FutureResult<Connection> var2);
    }
}

