/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import org.jboss.as.network.ClientMapping;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.IndexExternalizer;

public class ClientMappingExternalizer
implements Externalizer<ClientMapping> {
    public void writeObject(ObjectOutput output, ClientMapping mapping) throws IOException {
        byte[] address = mapping.getSourceNetworkAddress().getAddress();
        IndexExternalizer.UNSIGNED_BYTE.writeData((DataOutput)output, address.length);
        output.write(address);
        IndexExternalizer.UNSIGNED_BYTE.writeData((DataOutput)output, mapping.getSourceNetworkMaskBits());
        output.writeUTF(mapping.getDestinationAddress());
        IndexExternalizer.UNSIGNED_SHORT.writeData((DataOutput)output, mapping.getDestinationPort());
    }

    public ClientMapping readObject(ObjectInput input) throws IOException {
        byte[] sourceAddress = new byte[IndexExternalizer.UNSIGNED_BYTE.readData((DataInput)input)];
        input.readFully(sourceAddress);
        int sourceNetworkMaskBits = IndexExternalizer.UNSIGNED_BYTE.readData((DataInput)input);
        String destAddress = input.readUTF();
        int destPort = IndexExternalizer.UNSIGNED_SHORT.readData((DataInput)input);
        return new ClientMapping(InetAddress.getByAddress(sourceAddress), sourceNetworkMaskBits, destAddress, destPort);
    }

    public Class<ClientMapping> getTargetClass() {
        return ClientMapping.class;
    }
}

