/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso;

import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.api.Deployment;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.clustering.web.undertow.UndertowBinaryRequirement;
import org.wildfly.clustering.web.undertow.UndertowRequirement;
import org.wildfly.clustering.web.undertow.sso.SessionManagerRegistry;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.UndertowEventListener;
import org.wildfly.extension.undertow.UndertowService;

public class SessionManagerRegistryBuilder
implements CapabilityServiceBuilder<SessionManagerRegistry>,
Service<SessionManagerRegistry>,
SessionManagerRegistry,
UndertowEventListener {
    private final ServiceName name;
    private final String serverName;
    private final String hostName;
    private final ValueDependency<SessionListener> listener;
    private final ConcurrentMap<String, SessionManager> managers = new ConcurrentHashMap<String, SessionManager>();
    private volatile ValueDependency<UndertowService> service;
    private volatile ValueDependency<Host> host;

    public SessionManagerRegistryBuilder(ServiceName name, String serverName, String hostName, ValueDependency<SessionListener> listener) {
        this.name = name;
        this.serverName = serverName;
        this.hostName = hostName;
        this.listener = listener;
    }

    public ServiceName getServiceName() {
        return this.name;
    }

    public Builder<SessionManagerRegistry> configure(CapabilityServiceSupport support) {
        this.service = new InjectedValueDependency(UndertowRequirement.UNDERTOW.getServiceName(support), UndertowService.class);
        this.host = new InjectedValueDependency(UndertowBinaryRequirement.HOST.getServiceName(support, this.serverName, this.hostName), Host.class);
        return this;
    }

    public ServiceBuilder<SessionManagerRegistry> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.name, (Service)this).setInitialMode(ServiceController.Mode.ON_DEMAND);
        Stream.of(this.listener, this.service, this.host).forEach(dependency -> dependency.register(builder));
        return builder;
    }

    public SessionManagerRegistry getValue() {
        return this;
    }

    public void start(StartContext context) throws StartException {
        ((UndertowService)this.service.getValue()).registerListener((UndertowEventListener)this);
        ((Host)this.host.getValue()).getDeployments().forEach(deployment -> this.addDeployment((Deployment)deployment));
    }

    public void stop(StopContext context) {
        ((Host)this.host.getValue()).getDeployments().forEach(deployment -> this.removeDeployment((Deployment)deployment));
        ((UndertowService)this.service.getValue()).unregisterListener((UndertowEventListener)this);
    }

    private void addDeployment(Deployment deployment) {
        SessionManager manager = deployment.getSessionManager();
        if (this.managers.putIfAbsent(deployment.getDeploymentInfo().getDeploymentName(), deployment.getSessionManager()) == null) {
            manager.registerSessionListener((SessionListener)this.listener.getValue());
        }
    }

    private void removeDeployment(Deployment deployment) {
        if (this.managers.remove(deployment.getDeploymentInfo().getDeploymentName()) != null) {
            deployment.getSessionManager().removeSessionListener((SessionListener)this.listener.getValue());
        }
    }

    public void onDeploymentStart(Deployment deployment, Host host) {
        if (((Host)this.host.getValue()).getName().equals(host.getName())) {
            this.addDeployment(deployment);
        }
    }

    public void onDeploymentStop(Deployment deployment, Host host) {
        if (((Host)this.host.getValue()).getName().equals(host.getName())) {
            this.removeDeployment(deployment);
        }
    }

    @Override
    public SessionManager getSessionManager(String deployment) {
        return (SessionManager)this.managers.get(deployment);
    }
}

