/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.river;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.marshalling.AbstractMarshallerFactory;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.marshalling.reflect.SerializableClassRegistry;
import org.jboss.marshalling.river.RiverMarshaller;
import org.jboss.marshalling.river.RiverUnmarshaller;

public class RiverMarshallerFactory
extends AbstractMarshallerFactory {
    private final SerializableClassRegistry registry = AccessController.doPrivileged(new PrivilegedAction<SerializableClassRegistry>(){

        @Override
        public SerializableClassRegistry run() {
            return SerializableClassRegistry.getInstance();
        }
    });

    public Unmarshaller createUnmarshaller(MarshallingConfiguration configuration) throws IOException {
        return new RiverUnmarshaller(this, this.registry, configuration);
    }

    public Marshaller createMarshaller(MarshallingConfiguration configuration) throws IOException {
        return new RiverMarshaller(this, this.registry, configuration);
    }

    protected int getDefaultVersion() {
        return 4;
    }
}

