/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl;

import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.TopologyMember;

public class BackwardsCompatibilityUtils {
    private static int INITIAL_ACTIVEMQ_INCREMENTING_VERSION = 126;

    public static Pair<TransportConfiguration, TransportConfiguration> getTCPair(int clientIncrementingVersion, TopologyMember member) {
        if (clientIncrementingVersion < INITIAL_ACTIVEMQ_INCREMENTING_VERSION) {
            return new Pair<TransportConfiguration, TransportConfiguration>(BackwardsCompatibilityUtils.replaceClassName(member.getLive()), BackwardsCompatibilityUtils.replaceClassName(member.getBackup()));
        }
        return new Pair<TransportConfiguration, TransportConfiguration>(member.getLive(), member.getBackup());
    }

    private static TransportConfiguration replaceClassName(TransportConfiguration tc) {
        if (tc != null) {
            String className = tc.getFactoryClassName().replace("org.apache.activemq.artemis", "org.hornetq").replace("ActiveMQ", "HornetQ");
            return new TransportConfiguration(className, tc.getParams(), tc.getName());
        }
        return tc;
    }
}

