/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.core.management.client;

public class Process {

    public static enum Type {
        DOMAIN_SERVER("DOMAIN_SERVER"),
        EMBEDDED_SERVER("EMBEDDED_SERVER"),
        STANDALONE_SERVER("STANDALONE_SERVER"),
        HOST_CONTROLLER("HOST_CONTROLLER"),
        EMBEDDED_HOST_CONTROLLER("EMBEDDED_HOST_CONTROLLER"),
        APPLICATION_CLIENT("APPLICATION_CLIENT"),
        SELF_CONTAINED("SELF_CONTAINED");

        private final String type;

        private Type(String type) {
            this.type = type;
        }

        public static Type from(String processTypeName) {
            switch (processTypeName) {
                case "DOMAIN_SERVER": {
                    return DOMAIN_SERVER;
                }
                case "EMBEDDED_SERVER": {
                    return EMBEDDED_SERVER;
                }
                case "STANDALONE_SERVER": {
                    return STANDALONE_SERVER;
                }
                case "HOST_CONTROLLER": {
                    return HOST_CONTROLLER;
                }
                case "EMBEDDED_HOST_CONTROLLER": {
                    return EMBEDDED_HOST_CONTROLLER;
                }
                case "APPLICATION_CLIENT": {
                    return APPLICATION_CLIENT;
                }
                case "SELF_CONTAINED": {
                    return SELF_CONTAINED;
                }
            }
            return EMBEDDED_SERVER;
        }

        public String toString() {
            return this.type.toString();
        }
    }

    public static enum RunningMode {
        ADMIN_ONLY("admin-only"),
        NORMAL("normal");

        private final String mode;

        private RunningMode(String mode) {
            this.mode = mode;
        }

        public String toString() {
            return this.mode;
        }

        public static RunningMode from(String runningMode) {
            switch (runningMode) {
                case "ADMIN_ONLY": {
                    return ADMIN_ONLY;
                }
            }
            return NORMAL;
        }
    }

    public static enum RunningState {
        STOPPED("stopped"),
        STARTING("starting"),
        PRE_SUSPEND("pre-suspend"),
        NORMAL("normal"),
        ADMIN_ONLY("admin-only"),
        SUSPENDING("suspending"),
        SUSPENDED("suspended"),
        STOPPING("stopping");

        private final String state;

        private RunningState(String state) {
            this.state = state;
        }

        public String toString() {
            return this.state;
        }
    }

    public static enum RuntimeConfigurationState {
        STARTING("starting"),
        RUNNING("ok"),
        RELOAD_REQUIRED("reload-required"),
        RESTART_REQUIRED("restart-required"),
        STOPPING("stopping"),
        STOPPED("stopped");

        private final String state;

        private RuntimeConfigurationState(String state) {
            this.state = state;
        }

        public String toString() {
            return this.state;
        }
    }
}

