/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.RequestLimit;
import io.undertow.util.Methods;
import org.jboss.as.domain.http.server.DomainUtil;

class StreamReadLimitHandler
implements HttpHandler {
    private static final int MAX_STREAM_SENDERS = 2;
    private static final int MAX_STREAM_RESPONSES = 128;
    private final RequestLimit requestLimit = new RequestLimit(2, 128);
    private final HttpHandler next;

    private StreamReadLimitHandler(HttpHandler next) {
        this.next = next;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (StreamReadLimitHandler.isStreamRead(exchange)) {
            this.requestLimit.handleRequest(exchange, this.next);
        } else {
            this.next.handleRequest(exchange);
        }
    }

    private static boolean isStreamRead(HttpServerExchange exchange) {
        return Methods.GET.equals(exchange.getRequestMethod()) && DomainUtil.getStreamIndex(exchange, exchange.getRequestHeaders()) > -1;
    }

    static HttpHandler wrap(HttpHandler next) {
        return new StreamReadLimitHandler(next);
    }
}

