/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.keycloak.common.util.CollectionUtil;
import org.keycloak.models.ClientModel;
import org.keycloak.protocol.oidc.utils.WebOriginsUtils;
import org.keycloak.representations.AccessToken;

public class Cors {
    private static final Logger logger = Logger.getLogger(Cors.class);
    public static final long DEFAULT_MAX_AGE = TimeUnit.HOURS.toSeconds(1L);
    public static final String DEFAULT_ALLOW_METHODS = "GET, HEAD, OPTIONS";
    public static final String DEFAULT_ALLOW_HEADERS = "Origin, Accept, X-Requested-With, Content-Type, Access-Control-Request-Method, Access-Control-Request-Headers";
    public static final String ORIGIN_HEADER = "Origin";
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    public static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    public static final String ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
    public static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    public static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN_WILDCARD = "*";
    public static final String INCLUDE_REDIRECTS = "+";
    private HttpRequest request;
    private Response.ResponseBuilder builder;
    private Set<String> allowedOrigins;
    private Set<String> allowedMethods;
    private Set<String> exposedHeaders;
    private boolean preflight;
    private boolean auth;

    public Cors(HttpRequest request, Response.ResponseBuilder response) {
        this.request = request;
        this.builder = response;
    }

    public Cors(HttpRequest request) {
        this.request = request;
    }

    public static Cors add(HttpRequest request, Response.ResponseBuilder response) {
        return new Cors(request, response);
    }

    public static Cors add(HttpRequest request) {
        return new Cors(request);
    }

    public Cors builder(Response.ResponseBuilder builder) {
        this.builder = builder;
        return this;
    }

    public Cors preflight() {
        this.preflight = true;
        return this;
    }

    public Cors auth() {
        this.auth = true;
        return this;
    }

    public Cors allowAllOrigins() {
        this.allowedOrigins = Collections.singleton(ACCESS_CONTROL_ALLOW_ORIGIN_WILDCARD);
        return this;
    }

    public Cors allowedOrigins(UriInfo uriInfo, ClientModel client) {
        if (client != null) {
            this.allowedOrigins = WebOriginsUtils.resolveValidWebOrigins(uriInfo, client);
        }
        return this;
    }

    public Cors allowedOrigins(AccessToken token) {
        if (token != null) {
            this.allowedOrigins = token.getAllowedOrigins();
        }
        return this;
    }

    public Cors allowedOrigins(String ... allowedOrigins) {
        if (allowedOrigins != null && allowedOrigins.length > 0) {
            this.allowedOrigins = new HashSet<String>(Arrays.asList(allowedOrigins));
        }
        return this;
    }

    public Cors allowedMethods(String ... allowedMethods) {
        this.allowedMethods = new HashSet<String>(Arrays.asList(allowedMethods));
        return this;
    }

    public Cors exposedHeaders(String ... exposedHeaders) {
        this.exposedHeaders = new HashSet<String>(Arrays.asList(exposedHeaders));
        return this;
    }

    public Response build() {
        String origin = (String)this.request.getHttpHeaders().getRequestHeaders().getFirst((Object)ORIGIN_HEADER);
        if (origin == null) {
            logger.trace((Object)"No origin header ignoring");
            return this.builder.build();
        }
        if (!(this.preflight || this.allowedOrigins != null && (this.allowedOrigins.contains(origin) || this.allowedOrigins.contains(ACCESS_CONTROL_ALLOW_ORIGIN_WILDCARD)))) {
            if (logger.isDebugEnabled()) {
                logger.debugv("Invalid CORS request: origin {0} not in allowed origins {1}", (Object)origin, (Object)Arrays.toString(this.allowedOrigins.toArray()));
            }
            return this.builder.build();
        }
        if (this.allowedOrigins != null && this.allowedOrigins.contains(ACCESS_CONTROL_ALLOW_ORIGIN_WILDCARD)) {
            this.builder.header(ACCESS_CONTROL_ALLOW_ORIGIN, (Object)ACCESS_CONTROL_ALLOW_ORIGIN_WILDCARD);
        } else {
            this.builder.header(ACCESS_CONTROL_ALLOW_ORIGIN, (Object)origin);
        }
        if (this.preflight) {
            if (this.allowedMethods != null) {
                this.builder.header(ACCESS_CONTROL_ALLOW_METHODS, (Object)CollectionUtil.join(this.allowedMethods));
            } else {
                this.builder.header(ACCESS_CONTROL_ALLOW_METHODS, (Object)DEFAULT_ALLOW_METHODS);
            }
        }
        if (!this.preflight && this.exposedHeaders != null) {
            this.builder.header(ACCESS_CONTROL_EXPOSE_HEADERS, (Object)CollectionUtil.join(this.exposedHeaders));
        }
        this.builder.header(ACCESS_CONTROL_ALLOW_CREDENTIALS, (Object)Boolean.toString(this.auth));
        if (this.preflight) {
            if (this.auth) {
                this.builder.header(ACCESS_CONTROL_ALLOW_HEADERS, (Object)String.format("%s, %s", DEFAULT_ALLOW_HEADERS, AUTHORIZATION_HEADER));
            } else {
                this.builder.header(ACCESS_CONTROL_ALLOW_HEADERS, (Object)DEFAULT_ALLOW_HEADERS);
            }
        }
        if (this.preflight) {
            this.builder.header(ACCESS_CONTROL_MAX_AGE, (Object)DEFAULT_MAX_AGE);
        }
        logger.debug((Object)"Added CORS headers to response");
        return this.builder.build();
    }

    public void build(HttpResponse response) {
        String origin = (String)this.request.getHttpHeaders().getRequestHeaders().getFirst((Object)ORIGIN_HEADER);
        if (origin == null) {
            logger.trace((Object)"No origin header ignoring");
            return;
        }
        if (!(this.preflight || this.allowedOrigins != null && (this.allowedOrigins.contains(origin) || this.allowedOrigins.contains(ACCESS_CONTROL_ALLOW_ORIGIN_WILDCARD)))) {
            if (logger.isDebugEnabled()) {
                logger.debugv("Invalid CORS request: origin {0} not in allowed origins {1}", (Object)origin, (Object)Arrays.toString(this.allowedOrigins.toArray()));
            }
            return;
        }
        if (this.allowedOrigins.contains(ACCESS_CONTROL_ALLOW_ORIGIN_WILDCARD)) {
            response.getOutputHeaders().add((Object)ACCESS_CONTROL_ALLOW_ORIGIN, (Object)ACCESS_CONTROL_ALLOW_ORIGIN_WILDCARD);
        } else {
            response.getOutputHeaders().add((Object)ACCESS_CONTROL_ALLOW_ORIGIN, (Object)origin);
        }
        if (this.preflight) {
            if (this.allowedMethods != null) {
                response.getOutputHeaders().add((Object)ACCESS_CONTROL_ALLOW_METHODS, (Object)CollectionUtil.join(this.allowedMethods));
            } else {
                response.getOutputHeaders().add((Object)ACCESS_CONTROL_ALLOW_METHODS, (Object)DEFAULT_ALLOW_METHODS);
            }
        }
        if (!this.preflight && this.exposedHeaders != null) {
            response.getOutputHeaders().add((Object)ACCESS_CONTROL_EXPOSE_HEADERS, (Object)CollectionUtil.join(this.exposedHeaders));
        }
        response.getOutputHeaders().add((Object)ACCESS_CONTROL_ALLOW_CREDENTIALS, (Object)Boolean.toString(this.auth));
        if (this.preflight) {
            if (this.auth) {
                response.getOutputHeaders().add((Object)ACCESS_CONTROL_ALLOW_HEADERS, (Object)String.format("%s, %s", DEFAULT_ALLOW_HEADERS, AUTHORIZATION_HEADER));
            } else {
                response.getOutputHeaders().add((Object)ACCESS_CONTROL_ALLOW_HEADERS, (Object)DEFAULT_ALLOW_HEADERS);
            }
        }
        if (this.preflight) {
            response.getOutputHeaders().add((Object)ACCESS_CONTROL_MAX_AGE, (Object)DEFAULT_MAX_AGE);
        }
        logger.debug((Object)"Added CORS headers to response");
    }
}

