/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.cluster.ClusterEvent;

@SerializeWith(value=ExternalizerImpl.class)
public class AuthenticationSessionAuthNoteUpdateEvent
implements ClusterEvent {
    private String authSessionId;
    private String clientUUID;
    private Map<String, String> authNotesFragment;

    public static AuthenticationSessionAuthNoteUpdateEvent create(String authSessionId, String clientUUID, Map<String, String> authNotesFragment) {
        AuthenticationSessionAuthNoteUpdateEvent event = new AuthenticationSessionAuthNoteUpdateEvent();
        event.authSessionId = authSessionId;
        event.clientUUID = clientUUID;
        event.authNotesFragment = new LinkedHashMap<String, String>(authNotesFragment);
        return event;
    }

    public String getAuthSessionId() {
        return this.authSessionId;
    }

    public String getClientUUID() {
        return this.clientUUID;
    }

    public Map<String, String> getAuthNotesFragment() {
        return this.authNotesFragment;
    }

    public String toString() {
        return String.format("AuthenticationSessionAuthNoteUpdateEvent [ authSessionId=%s, clientUUID=%s, authNotesFragment=%s ]", this.authSessionId, this.clientUUID, this.authNotesFragment);
    }

    public static class ExternalizerImpl
    implements Externalizer<AuthenticationSessionAuthNoteUpdateEvent> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, AuthenticationSessionAuthNoteUpdateEvent value) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)value.authSessionId, (ObjectOutput)output);
            MarshallUtil.marshallString((String)value.clientUUID, (ObjectOutput)output);
            MarshallUtil.marshallMap((Map)value.authNotesFragment, (ObjectOutput)output);
        }

        public AuthenticationSessionAuthNoteUpdateEvent readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public AuthenticationSessionAuthNoteUpdateEvent readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            return AuthenticationSessionAuthNoteUpdateEvent.create(MarshallUtil.unmarshallString((ObjectInput)input), MarshallUtil.unmarshallString((ObjectInput)input), MarshallUtil.unmarshallMap((ObjectInput)input, HashMap::new));
        }
    }
}

