/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.configuration.cache.EvictionConfiguration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.DefaultDataContainer;
import org.infinispan.container.entries.MarshalledValueEntrySizeCalculator;
import org.infinispan.container.entries.PrimitiveEntrySizeCalculator;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionType;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;

@DefaultFactoryFor(classes={DataContainer.class})
public class DataContainerFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    @Override
    public <T> T construct(Class<T> componentType) {
        DefaultDataContainer dataContainer;
        if (this.configuration.dataContainer().dataContainer() != null) {
            return (T)this.configuration.dataContainer().dataContainer();
        }
        EvictionStrategy st = this.configuration.eviction().strategy();
        int level = this.configuration.locking().concurrencyLevel();
        Equivalence keyEquivalence = this.configuration.dataContainer().keyEquivalence();
        long thresholdSize = this.configuration.eviction().size();
        if (thresholdSize < 0L) {
            return (T)DefaultDataContainer.unBoundedDataContainer(level, keyEquivalence);
        }
        switch (st) {
            case NONE: 
            case MANUAL: {
                return (T)DefaultDataContainer.unBoundedDataContainer(level, keyEquivalence);
            }
            case UNORDERED: 
            case LRU: {
                if (this.configuration.eviction().type() == EvictionType.MEMORY) {
                    PrimitiveEntrySizeCalculator esc = this.configuration.storeAsBinary().storeKeysAsBinary() && this.configuration.storeAsBinary().storeValuesAsBinary() ? new MarshalledValueEntrySizeCalculator() : new PrimitiveEntrySizeCalculator();
                    dataContainer = DefaultDataContainer.boundedDataContainer(level, thresholdSize, st, this.configuration.eviction().threadPolicy(), keyEquivalence, esc);
                    break;
                }
            }
            case FIFO: 
            case LIRS: {
                dataContainer = DefaultDataContainer.boundedDataContainer(level, thresholdSize, st, this.configuration.eviction().threadPolicy(), keyEquivalence, this.configuration.eviction().type());
                break;
            }
            default: {
                throw new CacheConfigurationException("Unknown eviction strategy " + (Object)((Object)this.configuration.eviction().strategy()));
            }
        }
        this.configuration.eviction().attributes().attribute(EvictionConfiguration.SIZE).addListener((newSize, old) -> dataContainer.resize((Long)newSize.get()));
        return (T)dataContainer;
    }
}

