/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ServerConnection;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.UUID;
import org.jboss.logging.Logger;
import org.jboss.security.negotiation.MessageFactory;
import org.jboss.security.negotiation.NegotiationException;
import org.jboss.security.negotiation.NegotiationMessage;
import org.jboss.security.negotiation.common.MessageTrace;
import org.jboss.security.negotiation.common.NegotiationContext;
import org.picketbox.commons.cipher.Base64;

public class NegotiationMechanism
implements AuthenticationMechanism {
    private static final AttachmentKey<NegotiationMessage> MESSAGE_KEY = AttachmentKey.create(NegotiationMessage.class);
    private static final Logger log = Logger.getLogger(NegotiationMechanism.class);
    private static final String NEGOTIATION_PLAIN = Headers.NEGOTIATE.toString();
    private static final String NEGOTIATE_PREFIX = Headers.NEGOTIATE + " ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        log.trace((Object)"Authenticating user");
        HeaderValues authHeaders = exchange.getRequestHeaders().get(Headers.AUTHORIZATION);
        if (authHeaders != null) {
            for (String current : authHeaders) {
                if (!current.startsWith(NEGOTIATE_PREFIX)) continue;
                String authTokenBase64 = current.substring(NEGOTIATE_PREFIX.length());
                byte[] authToken = Base64.decode((String)authTokenBase64);
                ByteArrayInputStream authTokenIS = new ByteArrayInputStream(authToken);
                MessageTrace.logRequestBase64(authTokenBase64);
                MessageTrace.logRequestHex(authToken);
                ServerConnection connection = exchange.getConnection();
                NegotiationContext negContext = (NegotiationContext)connection.getAttachment(NegotiationContext.ATTACHMENT_KEY);
                if (negContext == null) {
                    negContext = new NegotiationContext();
                    connection.putAttachment(NegotiationContext.ATTACHMENT_KEY, (Object)negContext);
                }
                try {
                    MessageFactory mf = MessageFactory.newInstance();
                    if (!mf.accepts(authTokenIS)) {
                        throw new IOException("Unsupported negotiation mechanism.");
                    }
                    negContext.setRequestMessage(mf.createMessage(authTokenIS));
                }
                catch (IOException | NegotiationException e) {
                    log.debug((Object)e);
                    return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
                }
                String username = negContext.getUsername();
                if (username == null || username.length() == 0) {
                    username = UUID.randomUUID().toString();
                    negContext.setUsername(username);
                }
                IdentityManager identityManager = this.getIdentityManager(securityContext);
                try {
                    negContext.associate();
                    Account account = identityManager.verify(username, null);
                    if (account != null) {
                        securityContext.authenticationComplete(account, "SPNEGO", true);
                        NegotiationMessage responseMessage = negContext.getResponseMessage();
                        if (responseMessage != null) {
                            ByteArrayOutputStream responseMessageOS = new ByteArrayOutputStream();
                            try {
                                responseMessage.writeTo(responseMessageOS, true);
                            }
                            catch (IOException e) {
                                throw new IllegalStateException(e);
                            }
                            String responseHeader = responseMessageOS.toString();
                            MessageTrace.logResponseBase64(responseHeader);
                            exchange.getResponseHeaders().put(Headers.WWW_AUTHENTICATE, NEGOTIATE_PREFIX + responseHeader);
                        }
                        connection.removeAttachment(NegotiationContext.ATTACHMENT_KEY);
                        AuthenticationMechanism.AuthenticationMechanismOutcome authenticationMechanismOutcome = AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
                        return authenticationMechanismOutcome;
                    }
                    exchange.putAttachment(MESSAGE_KEY, (Object)negContext.getResponseMessage());
                }
                finally {
                    negContext.clear();
                }
                return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    private IdentityManager getIdentityManager(SecurityContext securityContext) {
        return securityContext.getIdentityManager();
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        String header;
        NegotiationMessage responseMessage = (NegotiationMessage)exchange.getAttachment(MESSAGE_KEY);
        if (responseMessage != null) {
            ByteArrayOutputStream responseMessageOS = new ByteArrayOutputStream();
            try {
                responseMessage.writeTo(responseMessageOS, true);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            String responseHeader = responseMessageOS.toString();
            MessageTrace.logResponseBase64(responseHeader);
            header = NEGOTIATE_PREFIX + responseHeader;
        } else {
            header = NEGOTIATION_PLAIN;
        }
        exchange.getResponseHeaders().put(Headers.WWW_AUTHENTICATE, header);
        exchange.setStatusCode(401);
        return new AuthenticationMechanism.ChallengeResult(true, Integer.valueOf(401));
    }
}

