/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene53;

import java.io.IOException;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.NormsConsumer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;

class Lucene53NormsConsumer
extends NormsConsumer {
    IndexOutput data;
    IndexOutput meta;
    final int maxDoc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene53NormsConsumer(SegmentWriteState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        boolean success = false;
        try {
            String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
            this.data = state.directory.createOutput(dataName, state.context);
            CodecUtil.writeIndexHeader(this.data, dataCodec, 0, state.segmentInfo.getId(), state.segmentSuffix);
            String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
            this.meta = state.directory.createOutput(metaName, state.context);
            CodecUtil.writeIndexHeader(this.meta, metaCodec, 0, state.segmentInfo.getId(), state.segmentSuffix);
            this.maxDoc = state.segmentInfo.maxDoc();
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    @Override
    public void addNormsField(FieldInfo field, Iterable<Number> values) throws IOException {
        this.meta.writeVInt(field.number);
        long minValue = Long.MAX_VALUE;
        long maxValue = Long.MIN_VALUE;
        int count = 0;
        for (Number nv : values) {
            if (nv == null) {
                throw new IllegalStateException("illegal norms data for field " + field.name + ", got null for value: " + count);
            }
            long v = nv.longValue();
            minValue = Math.min(minValue, v);
            maxValue = Math.max(maxValue, v);
            ++count;
        }
        if (count != this.maxDoc) {
            throw new IllegalStateException("illegal norms data for field " + field.name + ", expected count=" + this.maxDoc + ", got=" + count);
        }
        if (minValue == maxValue) {
            this.addConstant(minValue);
        } else if (minValue >= -128L && maxValue <= 127L) {
            this.addByte1(values);
        } else if (minValue >= -32768L && maxValue <= 32767L) {
            this.addByte2(values);
        } else if (minValue >= Integer.MIN_VALUE && maxValue <= Integer.MAX_VALUE) {
            this.addByte4(values);
        } else {
            this.addByte8(values);
        }
    }

    private void addConstant(long constant) throws IOException {
        this.meta.writeByte((byte)0);
        this.meta.writeLong(constant);
    }

    private void addByte1(Iterable<Number> values) throws IOException {
        this.meta.writeByte((byte)1);
        this.meta.writeLong(this.data.getFilePointer());
        for (Number value : values) {
            this.data.writeByte(value.byteValue());
        }
    }

    private void addByte2(Iterable<Number> values) throws IOException {
        this.meta.writeByte((byte)2);
        this.meta.writeLong(this.data.getFilePointer());
        for (Number value : values) {
            this.data.writeShort(value.shortValue());
        }
    }

    private void addByte4(Iterable<Number> values) throws IOException {
        this.meta.writeByte((byte)4);
        this.meta.writeLong(this.data.getFilePointer());
        for (Number value : values) {
            this.data.writeInt(value.intValue());
        }
    }

    private void addByte8(Iterable<Number> values) throws IOException {
        this.meta.writeByte((byte)8);
        this.meta.writeLong(this.data.getFilePointer());
        for (Number value : values) {
            this.data.writeLong(value.longValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        block7: {
            block6: {
                boolean success = false;
                try {
                    if (this.meta != null) {
                        this.meta.writeVInt(-1);
                        CodecUtil.writeFooter(this.meta);
                    }
                    if (this.data != null) {
                        CodecUtil.writeFooter(this.data);
                    }
                    if (!(success = true)) break block6;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(this.data, this.meta);
                    } else {
                        IOUtils.closeWhileHandlingException(this.data, this.meta);
                    }
                    this.data = null;
                    this.meta = null;
                    throw throwable;
                }
                IOUtils.close(this.data, this.meta);
                break block7;
            }
            IOUtils.closeWhileHandlingException(this.data, this.meta);
        }
        this.data = null;
        this.meta = null;
    }
}

