/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.provider.util;

import java.util.regex.Pattern;

public class IdentityBrokerState {
    private static final Pattern DOT = Pattern.compile("\\.");
    private final String decodedState;
    private final String clientId;
    private final String tabId;
    private final String encoded;

    public static IdentityBrokerState decoded(String state, String clientId, String tabId) {
        String encodedState = state + "." + clientId + "." + tabId;
        return new IdentityBrokerState(state, clientId, tabId, encodedState);
    }

    public static IdentityBrokerState encoded(String encodedState) {
        String[] decoded = DOT.split(encodedState, 3);
        String state = decoded.length > 0 ? decoded[0] : null;
        String clientId = decoded.length > 1 ? decoded[1] : null;
        String tabId = decoded.length > 2 ? decoded[2] : null;
        return new IdentityBrokerState(state, clientId, tabId, encodedState);
    }

    private IdentityBrokerState(String decodedStateParam, String clientId, String tabId, String encoded) {
        this.decodedState = decodedStateParam;
        this.clientId = clientId;
        this.tabId = tabId;
        this.encoded = encoded;
    }

    public String getDecodedState() {
        return this.decodedState;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getTabId() {
        return this.tabId;
    }

    public String getEncoded() {
        return this.encoded;
    }
}

