/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.config.impl;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.jboss.modcluster.config.JvmRouteFactory;
import org.jboss.modcluster.config.MCMPHandlerConfiguration;
import org.jboss.modcluster.config.ProxyConfiguration;
import org.jboss.modcluster.config.SessionDrainingStrategy;

public class MCMPHandlerConfigurationImpl
implements MCMPHandlerConfiguration {
    private final Collection<ProxyConfiguration> proxyConfigurations;
    private final String proxyURL;
    private final int socketTimeout;
    private final SocketFactory socketFactory;
    private final Map<String, Set<String>> excludedContextsPerHost;
    private final Boolean advertise;
    private final boolean autoEnableContexts;
    private final long stopContextTimeout;
    private final TimeUnit stopContextTimeoutUnit;
    private final JvmRouteFactory jvmRouteFactory;
    private final SessionDrainingStrategy sessionDrainingStrategy;

    public MCMPHandlerConfigurationImpl(Collection<ProxyConfiguration> proxyConfigurations, String proxyURL, int socketTimeout, SocketFactory socketFactory, Map<String, Set<String>> excludedContextsPerHost, Boolean advertise, boolean autoEnableContexts, long stopContextTimeout, TimeUnit stopContextTimeoutUnit, JvmRouteFactory jvmRouteFactory, SessionDrainingStrategy sessionDrainingStrategy) {
        this.proxyConfigurations = proxyConfigurations;
        this.proxyURL = proxyURL;
        this.socketTimeout = socketTimeout;
        this.socketFactory = socketFactory;
        this.excludedContextsPerHost = excludedContextsPerHost;
        this.advertise = advertise;
        this.autoEnableContexts = autoEnableContexts;
        this.stopContextTimeout = stopContextTimeout;
        this.stopContextTimeoutUnit = stopContextTimeoutUnit;
        this.jvmRouteFactory = jvmRouteFactory;
        this.sessionDrainingStrategy = sessionDrainingStrategy;
    }

    @Override
    public Collection<ProxyConfiguration> getProxyConfigurations() {
        return this.proxyConfigurations;
    }

    @Override
    @Deprecated
    public Collection<InetSocketAddress> getProxies() {
        LinkedList<InetSocketAddress> proxies = new LinkedList<InetSocketAddress>();
        for (ProxyConfiguration proxy : this.proxyConfigurations) {
            proxies.add(proxy.getRemoteAddress());
        }
        return proxies;
    }

    @Override
    public String getProxyURL() {
        return this.proxyURL;
    }

    @Override
    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    @Override
    @Deprecated
    public boolean isSsl() {
        return this.socketFactory instanceof SSLSocketFactory;
    }

    @Override
    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    @Override
    public Map<String, Set<String>> getExcludedContextsPerHost() {
        return this.excludedContextsPerHost;
    }

    @Override
    public Boolean getAdvertise() {
        return this.advertise;
    }

    @Override
    public boolean isAutoEnableContexts() {
        return this.autoEnableContexts;
    }

    @Override
    public long getStopContextTimeout() {
        return this.stopContextTimeout;
    }

    @Override
    public TimeUnit getStopContextTimeoutUnit() {
        return this.stopContextTimeoutUnit;
    }

    @Override
    public JvmRouteFactory getJvmRouteFactory() {
        return this.jvmRouteFactory;
    }

    @Override
    public SessionDrainingStrategy getSessionDrainingStrategy() {
        return this.sessionDrainingStrategy;
    }
}

