/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.session;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.jboss.logging.Logger;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.jpa.session.PersistentClientSessionEntity;
import org.keycloak.models.jpa.session.PersistentUserSessionEntity;
import org.keycloak.models.session.PersistentAuthenticatedClientSessionAdapter;
import org.keycloak.models.session.PersistentClientSessionModel;
import org.keycloak.models.session.PersistentUserSessionAdapter;
import org.keycloak.models.session.PersistentUserSessionModel;
import org.keycloak.models.session.UserSessionPersisterProvider;

public class JpaUserSessionPersisterProvider
implements UserSessionPersisterProvider {
    private static final Logger logger = Logger.getLogger(JpaUserSessionPersisterProvider.class);
    private final KeycloakSession session;
    private final EntityManager em;

    public JpaUserSessionPersisterProvider(KeycloakSession session, EntityManager em) {
        this.session = session;
        this.em = em;
    }

    public void createUserSession(UserSessionModel userSession, boolean offline) {
        PersistentUserSessionAdapter adapter = new PersistentUserSessionAdapter(userSession);
        PersistentUserSessionModel model = adapter.getUpdatedModel();
        PersistentUserSessionEntity entity = new PersistentUserSessionEntity();
        entity.setUserSessionId(model.getUserSessionId());
        entity.setRealmId(adapter.getRealm().getId());
        entity.setUserId(adapter.getUser().getId());
        String offlineStr = this.offlineToString(offline);
        entity.setOffline(offlineStr);
        entity.setLastSessionRefresh(model.getLastSessionRefresh());
        entity.setData(model.getData());
        this.em.persist((Object)entity);
        this.em.flush();
    }

    public void createClientSession(AuthenticatedClientSessionModel clientSession, boolean offline) {
        PersistentAuthenticatedClientSessionAdapter adapter = new PersistentAuthenticatedClientSessionAdapter(clientSession);
        PersistentClientSessionModel model = adapter.getUpdatedModel();
        PersistentClientSessionEntity entity = new PersistentClientSessionEntity();
        entity.setClientId(clientSession.getClient().getId());
        entity.setTimestamp(clientSession.getTimestamp());
        String offlineStr = this.offlineToString(offline);
        entity.setOffline(offlineStr);
        entity.setUserSessionId(clientSession.getUserSession().getId());
        entity.setData(model.getData());
        this.em.persist((Object)entity);
        this.em.flush();
    }

    public void updateUserSession(UserSessionModel userSession, boolean offline) {
        PersistentUserSessionAdapter adapter = userSession instanceof PersistentUserSessionAdapter ? (PersistentUserSessionAdapter)userSession : new PersistentUserSessionAdapter(userSession);
        PersistentUserSessionModel model = adapter.getUpdatedModel();
        String offlineStr = this.offlineToString(offline);
        PersistentUserSessionEntity entity = (PersistentUserSessionEntity)this.em.find(PersistentUserSessionEntity.class, (Object)new PersistentUserSessionEntity.Key(userSession.getId(), offlineStr));
        if (entity == null) {
            throw new ModelException("UserSession with ID " + userSession.getId() + ", offline: " + offline + " not found");
        }
        entity.setLastSessionRefresh(model.getLastSessionRefresh());
        entity.setData(model.getData());
    }

    public void removeUserSession(String userSessionId, boolean offline) {
        String offlineStr = this.offlineToString(offline);
        this.em.createNamedQuery("deleteClientSessionsByUserSession").setParameter("userSessionId", (Object)userSessionId).setParameter("offline", (Object)offlineStr).executeUpdate();
        PersistentUserSessionEntity sessionEntity = (PersistentUserSessionEntity)this.em.find(PersistentUserSessionEntity.class, (Object)new PersistentUserSessionEntity.Key(userSessionId, offlineStr));
        if (sessionEntity != null) {
            this.em.remove((Object)sessionEntity);
            this.em.flush();
        }
    }

    public void removeClientSession(String userSessionId, String clientUUID, boolean offline) {
        String offlineStr = this.offlineToString(offline);
        PersistentClientSessionEntity sessionEntity = (PersistentClientSessionEntity)this.em.find(PersistentClientSessionEntity.class, (Object)new PersistentClientSessionEntity.Key(userSessionId, clientUUID, offlineStr));
        if (sessionEntity != null) {
            this.em.remove((Object)sessionEntity);
            List<PersistentClientSessionEntity> clientSessions = this.getClientSessionsByUserSession(sessionEntity.getUserSessionId(), offline);
            if (clientSessions.size() == 0) {
                offlineStr = this.offlineToString(offline);
                PersistentUserSessionEntity userSessionEntity = (PersistentUserSessionEntity)this.em.find(PersistentUserSessionEntity.class, (Object)new PersistentUserSessionEntity.Key(sessionEntity.getUserSessionId(), offlineStr));
                if (userSessionEntity != null) {
                    this.em.remove((Object)userSessionEntity);
                }
            }
            this.em.flush();
        }
    }

    private List<PersistentClientSessionEntity> getClientSessionsByUserSession(String userSessionId, boolean offline) {
        String offlineStr = this.offlineToString(offline);
        TypedQuery query = this.em.createNamedQuery("findClientSessionsByUserSession", PersistentClientSessionEntity.class);
        query.setParameter("userSessionId", (Object)userSessionId);
        query.setParameter("offline", (Object)offlineStr);
        return query.getResultList();
    }

    public void onRealmRemoved(RealmModel realm) {
        int num = this.em.createNamedQuery("deleteClientSessionsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteUserSessionsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
    }

    public void onClientRemoved(RealmModel realm, ClientModel client) {
        this.onClientRemoved(client.getId());
    }

    private void onClientRemoved(String clientUUID) {
        int num = this.em.createNamedQuery("deleteClientSessionsByClient").setParameter("clientId", (Object)clientUUID).executeUpdate();
        num = this.em.createNamedQuery("deleteDetachedUserSessions").executeUpdate();
    }

    public void onUserRemoved(RealmModel realm, UserModel user) {
        this.onUserRemoved(realm, user.getId());
    }

    private void onUserRemoved(RealmModel realm, String userId) {
        int num = this.em.createNamedQuery("deleteClientSessionsByUser").setParameter("userId", (Object)userId).executeUpdate();
        num = this.em.createNamedQuery("deleteUserSessionsByUser").setParameter("userId", (Object)userId).executeUpdate();
    }

    public void clearDetachedUserSessions() {
        int num = this.em.createNamedQuery("deleteDetachedClientSessions").executeUpdate();
        num = this.em.createNamedQuery("deleteDetachedUserSessions").executeUpdate();
    }

    public void updateAllTimestamps(int time) {
        int num = this.em.createNamedQuery("updateClientSessionsTimestamps").setParameter("timestamp", (Object)time).executeUpdate();
        num = this.em.createNamedQuery("updateUserSessionsTimestamps").setParameter("lastSessionRefresh", (Object)time).executeUpdate();
    }

    public List<UserSessionModel> loadUserSessions(int firstResult, int maxResults, boolean offline) {
        String offlineStr = this.offlineToString(offline);
        TypedQuery query = this.em.createNamedQuery("findUserSessions", PersistentUserSessionEntity.class);
        query.setParameter("offline", (Object)offlineStr);
        if (firstResult != -1) {
            query.setFirstResult(firstResult);
        }
        if (maxResults != -1) {
            query.setMaxResults(maxResults);
        }
        List results = query.getResultList();
        ArrayList<UserSessionModel> result = new ArrayList<UserSessionModel>();
        ArrayList<String> userSessionIds = new ArrayList<String>();
        for (PersistentUserSessionEntity entity : results) {
            RealmModel realm = this.session.realms().getRealm(entity.getRealmId());
            try {
                UserModel user = this.session.users().getUserById(entity.getUserId(), realm);
                if (user == null) {
                    this.onUserRemoved(realm, entity.getUserId());
                    return this.loadUserSessions(firstResult, maxResults, offline);
                }
            }
            catch (Exception e) {
                logger.debugv((Throwable)e, "Failed to load user with id {0}", (Object)entity.getUserId());
            }
            result.add((UserSessionModel)this.toAdapter(realm, entity));
            userSessionIds.add(entity.getUserSessionId());
        }
        HashSet<String> removedClientUUIDs = new HashSet<String>();
        if (!userSessionIds.isEmpty()) {
            TypedQuery query2 = this.em.createNamedQuery("findClientSessionsByUserSessions", PersistentClientSessionEntity.class);
            query2.setParameter("userSessionIds", userSessionIds);
            query2.setParameter("offline", (Object)offlineStr);
            List clientSessions = query2.getResultList();
            int j = 0;
            for (UserSessionModel ss : result) {
                PersistentUserSessionAdapter userSession = (PersistentUserSessionAdapter)ss;
                Map currentClientSessions = userSession.getAuthenticatedClientSessions();
                boolean next = true;
                while (next && j < clientSessions.size()) {
                    PersistentClientSessionEntity clientSession = (PersistentClientSessionEntity)clientSessions.get(j);
                    if (clientSession.getUserSessionId().equals(userSession.getId())) {
                        PersistentAuthenticatedClientSessionAdapter clientSessAdapter = this.toAdapter(userSession.getRealm(), userSession, clientSession);
                        if (clientSessAdapter.getClient() == null) {
                            removedClientUUIDs.add(clientSession.getClientId());
                        } else {
                            currentClientSessions.put(clientSession.getClientId(), clientSessAdapter);
                        }
                        ++j;
                        continue;
                    }
                    next = false;
                }
            }
        }
        for (String clientUUID : removedClientUUIDs) {
            this.onClientRemoved(clientUUID);
        }
        return result;
    }

    private PersistentUserSessionAdapter toAdapter(RealmModel realm, PersistentUserSessionEntity entity) {
        PersistentUserSessionModel model = new PersistentUserSessionModel();
        model.setUserSessionId(entity.getUserSessionId());
        model.setLastSessionRefresh(entity.getLastSessionRefresh());
        model.setData(entity.getData());
        model.setOffline(this.offlineFromString(entity.getOffline()));
        HashMap clientSessions = new HashMap();
        return new PersistentUserSessionAdapter(this.session, model, realm, entity.getUserId(), clientSessions);
    }

    private PersistentAuthenticatedClientSessionAdapter toAdapter(RealmModel realm, PersistentUserSessionAdapter userSession, PersistentClientSessionEntity entity) {
        ClientModel client = realm.getClientById(entity.getClientId());
        PersistentClientSessionModel model = new PersistentClientSessionModel();
        model.setClientId(entity.getClientId());
        model.setUserSessionId(userSession.getId());
        model.setUserId(userSession.getUserId());
        model.setTimestamp(entity.getTimestamp());
        model.setData(entity.getData());
        return new PersistentAuthenticatedClientSessionAdapter(model, realm, client, (UserSessionModel)userSession);
    }

    public int getUserSessionsCount(boolean offline) {
        String offlineStr = this.offlineToString(offline);
        Query query = this.em.createNamedQuery("findUserSessionsCount");
        query.setParameter("offline", (Object)offlineStr);
        Number n = (Number)query.getSingleResult();
        return n.intValue();
    }

    public void close() {
    }

    private String offlineToString(boolean offline) {
        return offline ? "1" : "0";
    }

    private boolean offlineFromString(String offlineStr) {
        return "1".equals(offlineStr);
    }
}

