/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.CombinedTransformer;
import org.jboss.as.controller.transform.ExtensionTransformerRegistration;
import org.jboss.as.controller.transform.OperationRejectionPolicy;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.SubsystemTransformerRegistration;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemModel;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemRootResourceDefinition;
import org.jboss.as.ejb3.subsystem.PassivationStoreResourceDefinition;
import org.jboss.as.ejb3.subsystem.RemotingProfileResourceDefinition;
import org.jboss.as.ejb3.subsystem.StaticEJBDiscoveryDefinition;
import org.jboss.as.ejb3.subsystem.StrictMaxPoolResourceDefinition;
import org.jboss.as.ejb3.subsystem.TimerServiceResourceDefinition;
import org.jboss.dmr.ModelNode;

public class EJBTransformers
implements ExtensionTransformerRegistration {
    private static final ModelVersion VERSION_1_2_1 = ModelVersion.create((int)1, (int)2, (int)1);
    private static final ModelVersion VERSION_1_3_0 = ModelVersion.create((int)1, (int)3, (int)0);
    private static final ModelVersion VERSION_3_0_0 = ModelVersion.create((int)3, (int)0, (int)0);
    private static final ModelVersion VERSION_4_0_0 = ModelVersion.create((int)4, (int)0, (int)0);

    public String getSubsystemName() {
        return "ejb3";
    }

    public void registerTransformers(SubsystemTransformerRegistration subsystemRegistration) {
        EJBTransformers.registerTransformers_1_2_1(subsystemRegistration);
        EJBTransformers.registerTimerTransformers_1_3_0(subsystemRegistration);
        EJBTransformers.registerTransformers_3_0_0(subsystemRegistration);
        EJBTransformers.registerTransformers_4_0_0(subsystemRegistration);
    }

    private static void registerTransformers_1_2_1(SubsystemTransformerRegistration subsystemRegistration) {
        EJBTransformers.registerTransformers_1_2_1_and_1_3_0(subsystemRegistration, VERSION_1_2_1);
    }

    private static void registerTimerTransformers_1_3_0(SubsystemTransformerRegistration subsystemRegistration) {
        EJBTransformers.registerTransformers_1_2_1_and_1_3_0(subsystemRegistration, VERSION_1_3_0);
    }

    private static void registerTransformers_1_2_1_and_1_3_0(SubsystemTransformerRegistration subsystemRegistration, ModelVersion version) {
        ResourceTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        builder.getAttributeBuilder().addRename("default-sfsb-cache", "default-clustered-sfsb-cache");
        builder.getAttributeBuilder().addRename("default-sfsb-passivation-disabled-cache", "default-sfsb-cache");
        builder.getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(true)}), new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.LOG_EJB_EXCEPTIONS});
        builder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.LOG_EJB_EXCEPTIONS});
        builder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.DISABLE_DEFAULT_EJB_PERMISSIONS});
        builder.getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(false)}), new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.DISABLE_DEFAULT_EJB_PERMISSIONS});
        builder.getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(false)}), new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.ALLOW_EJB_NAME_REGEX});
        builder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.ALLOW_EJB_NAME_REGEX});
        ((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(false)}), new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.ENABLE_GRACEFUL_TXN_SHUTDOWN})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.ENABLE_GRACEFUL_TXN_SHUTDOWN});
        EJBTransformers.registerPassivationStoreTransformers_1_2_1_and_1_3_0(builder);
        EJBTransformers.registerRemoteTransformers(builder);
        EJBTransformers.registerMdbDeliveryGroupTransformers(builder);
        EJBTransformers.registerStrictMaxPoolTransformers(builder);
        EJBTransformers.registerApplicationSecurityDomainDTransformers(builder);
        EJBTransformers.registerIdentityTransformers(builder);
        builder.rejectChildResource(PathElement.pathElement((String)"remoting-profile"));
        if (version.equals((Object)VERSION_1_2_1)) {
            EJBTransformers.registerTimerTransformers_1_2_0(builder);
        } else if (version.equals((Object)VERSION_1_3_0)) {
            EJBTransformers.registerTimerTransformers_1_3_0(builder);
        }
        builder.getAttributeBuilder().addRename("statistics-enabled", "enable-statistics");
        TransformationDescription.Tools.register((TransformationDescription)builder.build(), (SubsystemTransformerRegistration)subsystemRegistration, (ModelVersionRange)version);
    }

    private static void registerTransformers_3_0_0(SubsystemTransformerRegistration subsystemRegistration) {
        ResourceTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        ((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setValueConverter(AttributeConverter.Factory.createHardCoded((ModelNode)new ModelNode("hornetq-ra"), (boolean)true), new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.DEFAULT_RESOURCE_ADAPTER_NAME})).end();
        builder.getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(false)}), new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.ALLOW_EJB_NAME_REGEX});
        builder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.ALLOW_EJB_NAME_REGEX});
        builder.getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(false)}), new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.ENABLE_GRACEFUL_TXN_SHUTDOWN});
        builder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.ENABLE_GRACEFUL_TXN_SHUTDOWN});
        EJBTransformers.registerMdbDeliveryGroupTransformers(builder);
        EJBTransformers.registerRemoteTransformers(builder);
        EJBTransformers.registerStrictMaxPoolTransformers(builder);
        EJBTransformers.registerApplicationSecurityDomainDTransformers(builder);
        EJBTransformers.registerIdentityTransformers(builder);
        builder.getAttributeBuilder().addRename("statistics-enabled", "enable-statistics");
        TransformationDescription.Tools.register((TransformationDescription)builder.build(), (SubsystemTransformerRegistration)subsystemRegistration, (ModelVersionRange)VERSION_3_0_0);
    }

    private static void registerTransformers_4_0_0(SubsystemTransformerRegistration subsystemRegistration) {
        ResourceTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createSubsystemInstance();
        EJBTransformers.registerApplicationSecurityDomainDTransformers(builder);
        EJBTransformers.registerIdentityTransformers(builder);
        ((AttributeTransformationDescriptionBuilder)builder.addChildResource((ResourceDefinition)RemotingProfileResourceDefinition.INSTANCE).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{StaticEJBDiscoveryDefinition.INSTANCE})).end();
        builder.getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(false)}), new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.ALLOW_EJB_NAME_REGEX});
        builder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.ALLOW_EJB_NAME_REGEX});
        builder.getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(false)}), new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.ENABLE_GRACEFUL_TXN_SHUTDOWN});
        builder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.ENABLE_GRACEFUL_TXN_SHUTDOWN});
        builder.getAttributeBuilder().addRename("statistics-enabled", "enable-statistics");
        TransformationDescription.Tools.register((TransformationDescription)builder.build(), (SubsystemTransformerRegistration)subsystemRegistration, (ModelVersionRange)VERSION_4_0_0);
    }

    private static void registerRemoteTransformers(ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder remoteService = parent.addChildResource(EJB3SubsystemModel.REMOTE_SERVICE_PATH);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)remoteService.getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode("ejb")}), new String[]{"cluster"})).addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"cluster"})).setDiscard(DiscardAttributeChecker.ALWAYS, new String[]{"execute-in-worker"})).end();
    }

    private static void registerIdentityTransformers(ResourceTransformationDescriptionBuilder parent) {
        parent.rejectChildResource(EJB3SubsystemModel.IDENTITY_PATH);
    }

    private static void registerApplicationSecurityDomainDTransformers(ResourceTransformationDescriptionBuilder parent) {
        parent.rejectChildResource(PathElement.pathElement((String)"application-security-domain"));
    }

    private static void registerStrictMaxPoolTransformers(ResourceTransformationDescriptionBuilder parent) {
        ((AttributeTransformationDescriptionBuilder)parent.addChildResource(PathElement.pathElement((String)"strict-max-bean-instance-pool")).getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(StrictMaxPoolResourceDefinition.DeriveSize.NONE.toString())}), new AttributeDefinition[]{StrictMaxPoolResourceDefinition.DERIVE_SIZE})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{StrictMaxPoolResourceDefinition.DERIVE_SIZE});
    }

    private static void registerMdbDeliveryGroupTransformers(ResourceTransformationDescriptionBuilder parent) {
        parent.rejectChildResource(PathElement.pathElement((String)"mdb-delivery-group"));
    }

    private static void registerTimerTransformers_1_2_0(ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder timerService = parent.addChildResource(EJB3SubsystemModel.TIMER_SERVICE_PATH);
        EJBTransformers.registerDataStoreTransformers(timerService);
    }

    private static void registerDataStoreTransformers(ResourceTransformationDescriptionBuilder timerService) {
        DataStoreTransformer dataStoreTransformer = new DataStoreTransformer();
        ((AttributeTransformationDescriptionBuilder)timerService.getAttributeBuilder().setDiscard(DiscardAttributeChecker.ALWAYS, new String[]{"default-data-store"})).end();
        timerService.discardOperations(new String[]{"add"});
        timerService.setCustomResourceTransformer((ResourceTransformer)dataStoreTransformer);
        timerService.rejectChildResource(EJB3SubsystemModel.DATABASE_DATA_STORE_PATH);
        ResourceTransformationDescriptionBuilder fileDataStore = timerService.addChildRedirection(EJB3SubsystemModel.FILE_DATA_STORE_PATH, (current, builder) -> builder.getCurrent());
        fileDataStore.addOperationTransformationOverride("add").inheritResourceAttributeDefinitions().setCustomOperationTransformer((OperationTransformer)dataStoreTransformer).end();
    }

    private static void registerTimerTransformers_1_3_0(ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder timerService = parent.addChildResource(EJB3SubsystemModel.TIMER_SERVICE_PATH);
        ResourceTransformationDescriptionBuilder db = timerService.addChildResource(EJB3SubsystemModel.DATABASE_DATA_STORE_PATH);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)db.getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(-1)}), new String[]{"refresh-interval"})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(true)}), new String[]{"allow-execution"})).addRejectCheck(RejectAttributeChecker.DEFINED, new String[]{"refresh-interval", "allow-execution"});
    }

    private static void registerPassivationStoreTransformers_1_2_1_and_1_3_0(ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder child = parent.addChildRedirection(PassivationStoreResourceDefinition.INSTANCE.getPathElement(), PathElement.pathElement((String)"cluster-passivation-store"));
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)child.getAttributeBuilder().setValueConverter(AttributeConverter.Factory.createHardCoded((ModelNode)new ModelNode(true), (boolean)true), new String[]{"passivate-events-on-replicate"})).setValueConverter(AttributeConverter.Factory.createHardCoded((ModelNode)new ModelNode("default"), (boolean)true), new String[]{"client-mappings-cache"})).setValueConverter(AttributeConverter.Factory.createHardCoded((ModelNode)new ModelNode().set(Long.valueOf(Integer.MAX_VALUE).longValue()), (boolean)true), new String[]{"idle-timeout"})).setValueConverter(AttributeConverter.Factory.createHardCoded((ModelNode)new ModelNode().set(TimeUnit.SECONDS.name()), (boolean)true), new String[]{"idle-timeout-unit"});
    }

    private static class DataStoreTransformer
    implements CombinedTransformer {
        private DataStoreTransformer() {
        }

        public OperationTransformer.TransformedOperation transformOperation(final TransformationContext context, final PathAddress address, final ModelNode operation) throws OperationFailedException {
            Resource original = context.readResourceFromRoot(address);
            String defaultDataStore = original.getModel().get(TimerServiceResourceDefinition.DEFAULT_DATA_STORE.getName()).asString();
            boolean hasFileDataStore = original.hasChild(PathElement.pathElement((String)EJB3SubsystemModel.FILE_DATA_STORE_PATH.getKey(), (String)defaultDataStore));
            if (original.getChildren("file-data-store").size() > 1 || !hasFileDataStore) {
                return new OperationTransformer.TransformedOperation(operation, new OperationRejectionPolicy(){

                    public boolean rejectOperation(ModelNode preparedResult) {
                        return true;
                    }

                    public String getFailureDescription() {
                        return context.getLogger().getRejectedResourceWarning(address, operation);
                    }
                }, OperationResultTransformer.ORIGINAL_RESULT);
            }
            operation.get(TimerServiceResourceDefinition.THREAD_POOL_NAME.getName()).set(original.getModel().get(TimerServiceResourceDefinition.THREAD_POOL_NAME.getName()));
            return new OperationTransformer.TransformedOperation(operation, OperationResultTransformer.ORIGINAL_RESULT);
        }

        public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
            Resource untransformedResource = context.readResource(PathAddress.EMPTY_ADDRESS);
            ModelNode untransformedModel = Resource.Tools.readModel((Resource)untransformedResource);
            String defaultDataStore = untransformedModel.get(TimerServiceResourceDefinition.DEFAULT_DATA_STORE.getName()).asString();
            ModelNode transformed = resource.getModel();
            transformed.remove(TimerServiceResourceDefinition.DEFAULT_DATA_STORE.getName());
            ModelNode fileStore = untransformedModel.get(new String[]{"file-data-store", defaultDataStore});
            if (!fileStore.isDefined()) {
                this.rejectIncompatibleDataStores(context, address);
            } else if (untransformedModel.hasDefined("database-data-store") && untransformedModel.get("database-data-store").keys().size() > 0 || untransformedModel.get("file-data-store").keys().size() > 1) {
                this.rejectIncompatibleDataStores(context, address);
            }
            ModelNode path = fileStore.get("path");
            transformed.get("path").set(path);
            transformed.get("relative-to").set(fileStore.get("relative-to"));
            context.addTransformedResource(PathAddress.EMPTY_ADDRESS, resource);
        }

        private void rejectIncompatibleDataStores(ResourceTransformationContext context, PathAddress address) throws OperationFailedException {
            throw new OperationFailedException(EjbLogger.ROOT_LOGGER.untransformableTimerService(address));
        }
    }
}

