/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.protocol.StatusResponseType;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.parsers.ParserNamespaceSupport;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.SAMLExtensionsParser;
import org.keycloak.saml.processing.core.parsers.saml.SAMLStatusResponseTypeParser;

public class SAMLSloResponseParser
extends SAMLStatusResponseTypeParser
implements ParserNamespaceSupport {
    @Override
    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, JBossSAMLConstants.LOGOUT_RESPONSE.get());
        StatusResponseType response = this.parseBaseAttributes(startElement);
        while (xmlEventReader.hasNext() && (startElement = StaxParserUtil.peekNextStartElement(xmlEventReader)) != null) {
            String elementName = StaxParserUtil.getStartElementName(startElement);
            if (JBossSAMLConstants.ISSUER.get().equals(elementName)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                NameIDType issuer = new NameIDType();
                issuer.setValue(StaxParserUtil.getElementText(xmlEventReader));
                response.setIssuer(issuer);
                continue;
            }
            if (JBossSAMLConstants.SIGNATURE.get().equals(elementName)) {
                StaxParserUtil.bypassElementBlock(xmlEventReader, JBossSAMLConstants.SIGNATURE.get());
                continue;
            }
            if (JBossSAMLConstants.EXTENSIONS.get().equals(elementName)) {
                SAMLExtensionsParser extensionsParser = new SAMLExtensionsParser();
                response.setExtensions(extensionsParser.parse(xmlEventReader));
                continue;
            }
            if (!JBossSAMLConstants.STATUS.get().equals(elementName)) continue;
            response.setStatus(this.parseStatus(xmlEventReader));
        }
        return response;
    }

    @Override
    public boolean supports(QName qname) {
        return JBossSAMLURIConstants.PROTOCOL_NSURI.get().equals(qname.getNamespaceURI()) && JBossSAMLConstants.LOGOUT_RESPONSE.get().equals(qname.getLocalPart());
    }
}

