/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.hibernate.cache.infinispan.access.PutFromLoadValidator;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.context.InvocationContext;

public class EndInvalidationCommand
extends BaseRpcCommand {
    private Object[] keys;
    private Object lockOwner;
    private PutFromLoadValidator putFromLoadValidator;

    public EndInvalidationCommand(String cacheName) {
        this(cacheName, null, null);
    }

    public EndInvalidationCommand(String cacheName, Object[] keys, Object lockOwner) {
        super(cacheName);
        this.keys = keys;
        this.lockOwner = lockOwner;
    }

    public Object perform(InvocationContext ctx) throws Throwable {
        for (Object key : this.keys) {
            this.putFromLoadValidator.endInvalidatingKey(this.lockOwner, key);
        }
        return null;
    }

    public byte getCommandId() {
        return 121;
    }

    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallArray((Object[])this.keys, (ObjectOutput)output);
        output.writeObject(this.lockOwner);
    }

    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.keys = MarshallUtil.unmarshallArray((ObjectInput)input, Object[]::new);
        this.lockOwner = input.readObject();
    }

    public boolean isReturnValueExpected() {
        return false;
    }

    public boolean canBlock() {
        return true;
    }

    public void setPutFromLoadValidator(PutFromLoadValidator putFromLoadValidator) {
        this.putFromLoadValidator = putFromLoadValidator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EndInvalidationCommand)) {
            return false;
        }
        EndInvalidationCommand that = (EndInvalidationCommand)((Object)o);
        if (this.cacheName == null ? this.cacheName != null : !this.cacheName.equals(that.cacheName)) {
            return false;
        }
        if (!Arrays.equals(this.keys, that.keys)) {
            return false;
        }
        return !(this.lockOwner == null ? that.lockOwner != null : !this.lockOwner.equals(that.lockOwner));
    }

    public int hashCode() {
        int result = this.cacheName != null ? this.cacheName.hashCode() : 0;
        result = 31 * result + (this.keys != null ? Arrays.hashCode(this.keys) : 0);
        result = 31 * result + (this.lockOwner != null ? this.lockOwner.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("EndInvalidationCommand{");
        sb.append("cacheName=").append(this.cacheName);
        sb.append(", keys=").append(Arrays.toString(this.keys));
        sb.append(", sessionTransactionId=").append(this.lockOwner);
        sb.append('}');
        return sb.toString();
    }
}

