/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.stomp;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.artemis.core.protocol.stomp.StompConnection;
import org.apache.activemq.artemis.core.protocol.stomp.StompFrame;
import org.apache.activemq.artemis.core.protocol.stomp.VersionedStompFrameHandler;

public class ActiveMQStompException
extends Exception {
    public static final int NONE = 0;
    public static final int INVALID_EOL_V10 = 1;
    public static final int INVALID_COMMAND = 2;
    public static final int UNDEFINED_ESCAPE = 3;
    private static final long serialVersionUID = -274452327574950068L;
    private int code = 0;
    private final List<Header> headers = new ArrayList<Header>(10);
    private String body;
    private VersionedStompFrameHandler handler;
    private Boolean disconnect;

    public ActiveMQStompException(StompConnection connection, String msg) {
        super(msg);
        this.handler = connection.getFrameHandler();
    }

    public ActiveMQStompException(String msg) {
        super(msg);
        this.handler = null;
    }

    public ActiveMQStompException(String msg, Throwable t) {
        super(msg, t);
        this.body = t.getMessage();
        this.handler = null;
    }

    public ActiveMQStompException(int code, String details) {
        super(details);
        this.code = code;
        this.body = details;
        this.handler = null;
    }

    void addHeader(String header, String value) {
        this.headers.add(new Header(header, value));
    }

    public void setBody(String body) {
        this.body = body;
    }

    public StompFrame getFrame() {
        StompFrame frame = null;
        frame = this.handler == null ? new StompFrame("ERROR") : this.handler.createStompFrame("ERROR");
        frame.addHeader("message", this.getMessage());
        for (Header header : this.headers) {
            frame.addHeader(header.key, header.val);
        }
        if (this.body != null) {
            frame.addHeader("content-type", "text/plain");
            frame.setByteBody(this.body.getBytes(StandardCharsets.UTF_8));
        } else {
            frame.setByteBody(new byte[0]);
        }
        if (this.disconnect != null) {
            frame.setNeedsDisconnect(this.disconnect);
        }
        return frame;
    }

    public void setDisconnect(boolean b) {
        this.disconnect = b;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int newCode) {
        this.code = newCode;
    }

    public ActiveMQStompException setHandler(VersionedStompFrameHandler frameHandler) {
        this.handler = frameHandler;
        return this;
    }

    private static final class Header {
        public final String key;
        public final String val;

        private Header(String key, String val) {
            this.key = key;
            this.val = val;
        }
    }
}

