/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import javax.ejb.NoSuchEJBException;
import javax.security.sasl.SaslException;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.AbstractInvocationContext;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.AttachmentKey;
import org.jboss.ejb.client.ClusterAffinity;
import org.jboss.ejb.client.ClusterNodeSelector;
import org.jboss.ejb.client.DiscoveredURISelector;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBModuleIdentifier;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBRootContext;
import org.jboss.ejb.client.EJBSessionCreationInvocationContext;
import org.jboss.ejb.client.NamingEJBClientInterceptor;
import org.jboss.ejb.client.NodeAffinity;
import org.jboss.ejb.client.RequestSendFailedException;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.TransactionInterceptor;
import org.jboss.ejb.client.URIAffinity;
import org.jboss.ejb.client.annotation.ClientInterceptorPriority;
import org.wildfly.common.Assert;
import org.wildfly.common.net.CidrAddress;
import org.wildfly.common.net.Inet;
import org.wildfly.discovery.AttributeValue;
import org.wildfly.discovery.Discovery;
import org.wildfly.discovery.FilterSpec;
import org.wildfly.discovery.ServiceURL;
import org.wildfly.discovery.ServicesQueue;
import org.wildfly.naming.client.NamingProvider;

@ClientInterceptorPriority(value=200100)
public final class DiscoveryEJBClientInterceptor
implements EJBClientInterceptor {
    private static final Supplier<Discovery> DISCOVERY_SUPPLIER = AccessController.doPrivileged(Discovery.getContextManager()::getPrivilegedSupplier);
    private static final String[] NO_STRINGS = new String[0];
    public static final int PRIORITY = 200100;
    private static final AttachmentKey<Set<URI>> BL_KEY = new AttachmentKey();

    @Override
    public void handleInvocation(EJBClientInvocationContext context) throws Exception {
        if (context.getDestination() != null) {
            context.sendRequest();
            return;
        }
        List<Throwable> problems = this.executeDiscovery(context);
        try {
            context.sendRequest();
        }
        catch (NoSuchEJBException | RequestSendFailedException e) {
            if (this.isTargetMissing(e)) {
                this.processMissingTarget(context);
            }
            throw e;
        }
        finally {
            if (problems != null) {
                for (Throwable problem : problems) {
                    context.addSuppressed(problem);
                }
            }
        }
    }

    private boolean isTargetMissing(Exception e) {
        return !(e.getCause() instanceof SaslException);
    }

    @Override
    public Object handleInvocationResult(EJBClientInvocationContext context) throws Exception {
        Object result;
        try {
            result = context.getResult();
        }
        catch (NoSuchEJBException | RequestSendFailedException e) {
            if (this.isTargetMissing(e)) {
                this.processMissingTarget(context);
            }
            throw e;
        }
        EJBLocator<?> locator = context.getLocator();
        if (locator.isStateful() && locator.getAffinity() instanceof ClusterAffinity && context.getWeakAffinity() == Affinity.NONE) {
            Affinity targetAffinity = context.getTargetAffinity();
            if (targetAffinity != null) {
                context.setWeakAffinity(targetAffinity);
            } else {
                URI destination = context.getDestination();
                if (destination != null) {
                    context.setWeakAffinity(URIAffinity.forUri(destination));
                }
            }
        }
        return result;
    }

    @Override
    public SessionID handleSessionCreation(EJBSessionCreationInvocationContext context) throws Exception {
        SessionID sessionID;
        if (context.getDestination() != null) {
            return context.proceed();
        }
        List<Throwable> problems = this.executeDiscovery(context);
        try {
            sessionID = context.proceed();
        }
        catch (NoSuchEJBException | RequestSendFailedException e) {
            if (this.isTargetMissing(e)) {
                this.processMissingTarget(context);
            }
            throw EJBClientContext.withSuppressed(e, problems);
        }
        catch (Exception t) {
            throw EJBClientContext.withSuppressed(t, problems);
        }
        DiscoveryEJBClientInterceptor.setupSessionAffinities(context);
        return sessionID;
    }

    static void setupSessionAffinities(EJBSessionCreationInvocationContext context) {
        URI destination;
        Affinity targetAffinity;
        EJBLocator<?> locator = context.getLocator();
        if (locator.getAffinity() == Affinity.NONE) {
            targetAffinity = context.getTargetAffinity();
            if (targetAffinity != null) {
                context.setLocator(locator.withNewAffinity(targetAffinity));
            } else {
                destination = context.getDestination();
                if (destination != null) {
                    context.setLocator(locator.withNewAffinity(URIAffinity.forUri(destination)));
                }
            }
        }
        if (locator.getAffinity() instanceof ClusterAffinity && context.getWeakAffinity() == Affinity.NONE) {
            targetAffinity = context.getTargetAffinity();
            if (targetAffinity != null) {
                context.setWeakAffinity(targetAffinity);
            } else {
                destination = context.getDestination();
                if (destination != null) {
                    context.setWeakAffinity(URIAffinity.forUri(destination));
                }
            }
        }
    }

    private void processMissingTarget(AbstractInvocationContext context) {
        URI destination = context.getDestination();
        if (destination == null) {
            return;
        }
        DiscoveryEJBClientInterceptor.addBlackListedDestination(context, destination);
        context.setWeakAffinity(Affinity.NONE);
        context.setTargetAffinity(null);
        context.setDestination(null);
        context.requestRetry();
    }

    static boolean addBlackListedDestination(AbstractInvocationContext context, URI destination) {
        Assert.checkNotNullParam("context", context);
        if (destination != null) {
            Set appearing;
            Set set = context.getAttachment(BL_KEY);
            if (set == null && (appearing = (Set)context.putAttachmentIfAbsent(BL_KEY, set = new HashSet<URI>())) != null) {
                set = appearing;
            }
            Logs.INVOCATION.tracef("Blacklisting destination (locator = %s, weak affinity = %s, missing target = %s)", (Object)context.getLocator(), (Object)context.getWeakAffinity(), (Object)destination);
            return set.add((URI)destination);
        }
        return false;
    }

    static boolean isBlackListed(AbstractInvocationContext context, URI destination) {
        Set<URI> blacklist = context.getAttachment(BL_KEY);
        return blacklist != null && blacklist.contains(destination);
    }

    ServicesQueue discover(FilterSpec filterSpec) {
        return this.getDiscovery().discover(EJBClientContext.EJB_SERVICE_TYPE, filterSpec);
    }

    Discovery getDiscovery() {
        return DISCOVERY_SUPPLIER.get();
    }

    private List<Throwable> executeDiscovery(AbstractInvocationContext context) {
        assert (context.getDestination() == null);
        EJBLocator<?> locator = context.getLocator();
        Affinity affinity = locator.getAffinity();
        Affinity weakAffinity = context.getWeakAffinity();
        Logs.INVOCATION.tracef("Calling executeDiscovery(locator = %s, weak affinity = %s)", (Object)locator, (Object)weakAffinity);
        if (affinity instanceof URIAffinity || affinity == Affinity.LOCAL) {
            if (!DiscoveryEJBClientInterceptor.isBlackListed(context, affinity.getUri())) {
                context.setDestination(affinity.getUri());
                context.setTargetAffinity(affinity);
            }
            return null;
        }
        if (affinity == Affinity.NONE && weakAffinity instanceof URIAffinity) {
            if (!DiscoveryEJBClientInterceptor.isBlackListed(context, weakAffinity.getUri())) {
                context.setDestination(weakAffinity.getUri());
                context.setTargetAffinity(weakAffinity);
            }
            return null;
        }
        if (affinity == Affinity.NONE && weakAffinity instanceof NodeAffinity) {
            FilterSpec filterSpec = FilterSpec.equal("node", ((NodeAffinity)weakAffinity).getNodeName());
            return this.doFirstMatchDiscovery(context, filterSpec, null);
        }
        if (affinity instanceof NodeAffinity) {
            FilterSpec filterSpec = FilterSpec.equal("node", ((NodeAffinity)affinity).getNodeName());
            return this.doFirstMatchDiscovery(context, filterSpec, null);
        }
        if (affinity instanceof ClusterAffinity) {
            if (weakAffinity instanceof NodeAffinity) {
                FilterSpec filterSpec = FilterSpec.all(FilterSpec.equal("cluster", ((ClusterAffinity)affinity).getClusterName()), FilterSpec.equal("node", ((NodeAffinity)weakAffinity).getNodeName()));
                FilterSpec fallbackFilterSpec = FilterSpec.all(FilterSpec.equal("cluster", ((ClusterAffinity)affinity).getClusterName()), FilterSpec.hasAttribute("node"));
                return this.doFirstMatchDiscovery(context, filterSpec, fallbackFilterSpec);
            }
            if (weakAffinity instanceof URIAffinity || weakAffinity == Affinity.LOCAL) {
                context.setDestination(weakAffinity.getUri());
                context.setTargetAffinity(weakAffinity);
                return null;
            }
            FilterSpec filterSpec = FilterSpec.all(FilterSpec.equal("cluster", ((ClusterAffinity)affinity).getClusterName()));
            return this.doClusterDiscovery(context, filterSpec);
        }
        assert (affinity == Affinity.NONE);
        FilterSpec filterSpec = this.getFilterSpec(locator.getIdentifier().getModuleIdentifier());
        return this.doAnyDiscovery(context, filterSpec, locator);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Throwable> doFirstMatchDiscovery(AbstractInvocationContext context, FilterSpec filterSpec, FilterSpec fallbackFilterSpec) {
        List<Throwable> problems;
        Logs.INVOCATION.tracef("Performing first-match discovery(locator = %s, weak affinity = %s, filter spec = %s)", (Object)context.getLocator(), (Object)context.getWeakAffinity(), (Object)filterSpec);
        Set<URI> set = context.getAttachment(BL_KEY);
        try (ServicesQueue queue = this.discover(filterSpec);){
            ServiceURL serviceURL;
            while ((serviceURL = queue.takeService()) != null) {
                URI location = serviceURL.getLocationURI();
                if (set != null && set.contains(location)) continue;
                AttributeValue nodeValue = serviceURL.getFirstAttributeValue("node");
                if (nodeValue != null) {
                    context.setTargetAffinity(new NodeAffinity(nodeValue.toString()));
                } else {
                    context.setTargetAffinity(URIAffinity.forUri(location));
                }
                context.setDestination(location);
                Logs.INVOCATION.tracef("Performed first-match discovery(target affinity = %s, destination = %s)", (Object)context.getTargetAffinity(), (Object)context.getDestination());
                List<Throwable> list = queue.getProblems();
                return list;
            }
            problems = queue.getProblems();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Logs.MAIN.operationInterrupted();
        }
        if (fallbackFilterSpec == null) {
            Logs.INVOCATION.tracef("Performed first-match discovery, no match", new Object[0]);
            return problems;
        }
        assert (context.getLocator().getAffinity() instanceof ClusterAffinity);
        Logs.INVOCATION.tracef("Performed first-match discovery, no match, falling back to cluster discovery", new Object[0]);
        return DiscoveryEJBClientInterceptor.merge(problems, this.doClusterDiscovery(context, fallbackFilterSpec));
    }

    private static List<Throwable> merge(List<Throwable> problems, List<Throwable> problems2) {
        if (problems2.isEmpty()) {
            return problems;
        }
        if (problems.isEmpty()) {
            return problems2;
        }
        ArrayList<Throwable> problems3 = new ArrayList<Throwable>(problems.size() + problems2.size());
        problems3.addAll(problems);
        problems3.addAll(problems2);
        return problems3;
    }

    private List<Throwable> doAnyDiscovery(AbstractInvocationContext context, FilterSpec filterSpec, EJBLocator<?> locator) {
        Object selector;
        String nodeName;
        URI location;
        List<Throwable> problems;
        Logs.INVOCATION.tracef("Performing any discovery(locator = %s, weak affinity = %s, filter spec = %s)", (Object)context.getLocator(), (Object)context.getWeakAffinity(), (Object)filterSpec);
        Set<URI> blacklist = context.getAttachment(BL_KEY);
        HashMap<URI, String> nodes = new HashMap<URI, String>();
        HashMap<String, URI> uris = new HashMap<String, URI>();
        HashMap<URI, List<String>> clusterAssociations = new HashMap<URI, List<String>>();
        int nodeless = 0;
        try (ServicesQueue queue = this.discover(filterSpec);){
            ServiceURL serviceURL;
            while ((serviceURL = queue.takeService()) != null) {
                List<AttributeValue> clusters;
                URI location2 = serviceURL.getLocationURI();
                if (blacklist != null && blacklist.contains(location2)) continue;
                AttributeValue nodeValue = serviceURL.getFirstAttributeValue("node");
                if (nodeValue != null) {
                    if (nodes.remove(location2, null)) {
                        --nodeless;
                    }
                    String nodeName2 = nodeValue.toString();
                    nodes.put(location2, nodeName2);
                    uris.put(nodeName2, location2);
                } else if (nodes.putIfAbsent(location2, null) == null) {
                    ++nodeless;
                }
                if ((clusters = serviceURL.getAttributeValues("cluster")) == null) continue;
                for (AttributeValue cluster : clusters) {
                    List<String> list = clusterAssociations.putIfAbsent(location2, Collections.singletonList(cluster.toString()));
                    if (list == null) continue;
                    if (!(list instanceof ArrayList)) {
                        list = new ArrayList<String>(list);
                        clusterAssociations.put(location2, list);
                    }
                    list.add(cluster.toString());
                }
            }
            problems = queue.getProblems();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Logs.MAIN.operationInterrupted();
        }
        if (nodes.isEmpty()) {
            Logs.INVOCATION.tracef("Performed any discovery, no match", new Object[0]);
            return problems;
        }
        if (nodes.size() == 1) {
            Map.Entry entry = nodes.entrySet().iterator().next();
            location = (URI)entry.getKey();
            nodeName = (String)entry.getValue();
            Logs.INVOCATION.tracef("Performed first-match discovery(target affinity(node) = %s, destination = %s)", (Object)nodeName, (Object)location);
        } else if (nodeless == 0) {
            selector = context.getClientContext().getDeploymentNodeSelector();
            nodeName = selector.selectNode(nodes.values().toArray(NO_STRINGS), locator.getAppName(), locator.getModuleName(), locator.getDistinctName());
            if (nodeName == null) {
                throw Logs.INVOCATION.selectorReturnedNull(selector);
            }
            location = (URI)uris.get(nodeName);
            if (location == null) {
                throw Logs.INVOCATION.selectorReturnedUnknownNode(selector, nodeName);
            }
            Logs.INVOCATION.tracef("Performed first-match discovery, nodes > 1, deployment selector used(target affinity(node) = %s, destination = %s)", (Object)nodeName, (Object)location);
        } else {
            selector = DiscoveredURISelector.RANDOM;
            location = selector.selectNode(new ArrayList<URI>(nodes.keySet()), locator);
            if (location == null) {
                throw Logs.INVOCATION.selectorReturnedNull(selector);
            }
            nodeName = (String)nodes.get(location);
            if (nodeName == null) {
                throw Logs.INVOCATION.selectorReturnedUnknownNode(selector, location.toString());
            }
            Logs.INVOCATION.tracef("Performed first-match discovery, nodes > 1, URI selector used(target affinity(node) = %s, destination = %s)", (Object)nodeName, (Object)location);
        }
        this.selectCluster(context, clusterAssociations, location);
        context.setDestination(location);
        if (nodeName != null) {
            context.setTargetAffinity(new NodeAffinity(nodeName));
        }
        return problems;
    }

    private void selectCluster(AbstractInvocationContext context, Map<URI, List<String>> clusterAssociations, URI location) {
        List<String> associations = clusterAssociations.get(location);
        String cluster = null;
        if (associations != null) {
            String string = cluster = associations.size() == 1 ? associations.get(0) : associations.get(ThreadLocalRandom.current().nextInt(associations.size()));
        }
        if (cluster != null) {
            context.setInitialCluster(cluster);
        }
    }

    private List<Throwable> doClusterDiscovery(AbstractInvocationContext context, FilterSpec filterSpec) {
        List<Throwable> problems;
        Logs.INVOCATION.tracef("Performing cluster discovery(locator = %s, weak affinity = %s, filter spec = %s)", (Object)context.getLocator(), (Object)context.getWeakAffinity(), (Object)filterSpec);
        Map<String, URI> nodes = new HashMap<String, URI>();
        EJBClientContext clientContext = context.getClientContext();
        Set<URI> set = context.getAttachment(BL_KEY);
        try (ServicesQueue queue = this.discover(filterSpec);){
            ServiceURL serviceURL;
            while ((serviceURL = queue.takeService()) != null) {
                AttributeValue nodeNameValue;
                EJBReceiver eJBReceiver;
                URI location = serviceURL.getLocationURI();
                if (set != null && set.contains(location) || (eJBReceiver = clientContext.getTransportProvider(location.getScheme())) == null || !this.satisfiesSourceAddress(serviceURL, eJBReceiver) || (nodeNameValue = serviceURL.getFirstAttributeValue("node")) == null) continue;
                nodes.put(nodeNameValue.toString(), location);
            }
            problems = queue.getProblems();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Logs.MAIN.operationInterrupted();
        }
        nodes = this.tryFilterToPreferredNodes(context, nodes);
        EJBLocator<?> locator = context.getLocator();
        if (nodes.isEmpty()) {
            Logs.INVOCATION.tracef("Performed cluster discovery, nodes is empty; trying an initial ", new Object[0]);
            NamingProvider namingProvider = context.getAttachment(EJBRootContext.NAMING_PROVIDER_ATTACHMENT_KEY);
            if (namingProvider != null) {
                NamingEJBClientInterceptor.setNamingDestination(context, namingProvider);
            }
            return problems;
        }
        if (nodes.size() == 1) {
            Map.Entry<String, URI> entry = nodes.entrySet().iterator().next();
            String nodeName = entry.getKey();
            URI uri = entry.getValue();
            context.setTargetAffinity(new NodeAffinity(nodeName));
            context.setDestination(uri);
            Logs.INVOCATION.tracef("Performed cluster discovery (target affinity = %s, destination = %s)", (Object)context.getTargetAffinity(), (Object)context.getDestination());
            return problems;
        }
        ArrayList<String> availableNodes = new ArrayList<String>(nodes.size());
        ArrayList<String> connectedNodes = new ArrayList<String>(nodes.size());
        for (Map.Entry entry : nodes.entrySet()) {
            String nodeName = (String)entry.getKey();
            URI uri = (URI)entry.getValue();
            EJBReceiver transportProvider = clientContext.getTransportProvider(uri.getScheme());
            if (transportProvider == null) continue;
            availableNodes.add(nodeName);
            if (!transportProvider.isConnected(uri)) continue;
            connectedNodes.add(nodeName);
        }
        Logs.INVOCATION.tracef("Performing cluster discovery (connected nodes = %s, available nodes = %s)", (Object)connectedNodes, (Object)availableNodes);
        ClusterNodeSelector selector = clientContext.getClusterNodeSelector();
        String string = selector.selectNode(((ClusterAffinity)locator.getAffinity()).getClusterName(), connectedNodes.toArray(NO_STRINGS), availableNodes.toArray(NO_STRINGS));
        if (string == null) {
            throw EJBClientContext.withSuppressed(Logs.MAIN.selectorReturnedNull(selector), problems);
        }
        URI uri = nodes.get(string);
        if (uri == null) {
            throw EJBClientContext.withSuppressed(Logs.MAIN.selectorReturnedUnknownNode(selector, string), problems);
        }
        context.setDestination(uri);
        context.setTargetAffinity(new NodeAffinity(string));
        Logs.INVOCATION.tracef("Performed cluster discovery (target affinity = %s, destination = %s)", (Object)context.getTargetAffinity(), (Object)context.getDestination());
        return problems;
    }

    private Map<String, URI> tryFilterToPreferredNodes(AbstractInvocationContext context, Map<String, URI> nodes) {
        Collection<URI> attachment = context.getAttachment(TransactionInterceptor.PREFERRED_DESTINATIONS);
        if (attachment == null) {
            return nodes;
        }
        HashSet<URI> preferred = new HashSet<URI>(attachment);
        HashMap<String, URI> result = null;
        for (Map.Entry<String, URI> check : nodes.entrySet()) {
            if (!preferred.contains(check.getValue())) continue;
            if (result == null) {
                result = new HashMap<String, URI>(attachment.size());
            }
            result.put(check.getKey(), check.getValue());
        }
        return result == null ? nodes : result;
    }

    FilterSpec getFilterSpec(EJBModuleIdentifier identifier) {
        String appName = identifier.getAppName();
        String moduleName = identifier.getModuleName();
        String distinctName = identifier.getDistinctName();
        if (distinctName != null && !distinctName.isEmpty()) {
            if (appName.isEmpty()) {
                return FilterSpec.equal("ejb-module-distinct", moduleName + '/' + distinctName);
            }
            return FilterSpec.equal("ejb-module-distinct", appName + '/' + moduleName + '/' + distinctName);
        }
        if (appName.isEmpty()) {
            return FilterSpec.equal("ejb-module", moduleName);
        }
        return FilterSpec.equal("ejb-module", appName + '/' + moduleName);
    }

    boolean satisfiesSourceAddress(ServiceURL serviceURL, EJBReceiver receiver) {
        List<AttributeValue> values = serviceURL.getAttributeValues("source-ip");
        if (values.isEmpty()) {
            return true;
        }
        URI uri = serviceURL.getLocationURI();
        InetSocketAddress sourceAddress = receiver.getSourceAddress(new InetSocketAddress(uri.getHost(), uri.getPort()));
        InetAddress inetAddress = sourceAddress != null ? sourceAddress.getAddress() : null;
        for (AttributeValue value : values) {
            CidrAddress matchAddress;
            if (!value.isString() || (matchAddress = Inet.parseCidrAddress(value.toString())) == null || !(inetAddress == null ? matchAddress.getNetmaskBits() == 0 : matchAddress.matches(inetAddress))) continue;
            return true;
        }
        return false;
    }
}

